% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentroidCoreConcept.R
\name{drawCentroidCore}
\alias{drawCentroidCore}
\title{draw centroid of the core for 3 or 4 players}
\usage{
drawCentroidCore(v, holdOn = FALSE, colour = NA, label = TRUE,
  name = "centroid of core")
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}

\item{holdOn}{draws in a existing plot}

\item{colour}{draws the geometric object (i.e. point or convex polyhedron) with this colour, all colour names can be seen with "colors()"}

\item{label}{activates the labels for the figure}

\item{name}{set a name for the label}
}
\value{
None.
}
\description{
drawCentroidCore draws the centroid of the core for 3 or 4 players.
}
\examples{
library(CoopGame)
v <-c(1,2,3,60,60,60,142)
drawCentroidCore(v,colour="green")

}
\references{
Gillies D.B. (1953)  \emph{Some Theorems on n-person Games}, Ph.D. Thesis, Princeton University Press.

Aumann R.J. (1961) "The core of a cooperative game without side payments", Transactions of the American Mathematical Society 98(3), pp. 539--552

Peleg B. and Sudhoelter P. (2007) \emph{Theory of cooperative games}, 2nd Edition, Springer, pp. 27--49

Maschler M., Solan E. and Zamir S. (2013) \emph{Game Theory}, Cambridge University Press, pp. 686--747

Osborne M.J. and Rubinstein A. (1994) \emph{A Course in Game Theory}, MIT Press, pp. 257--275
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
