% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VAR.R
\name{VAR}
\alias{VAR}
\title{Vector autoregression}
\usage{
VAR(x, configuration = list(nlag = 1))
}
\arguments{
\item{x}{zoo data matrix}

\item{configuration}{model configuration}

\item{nlag}{Lag length}
}
\value{
Estimate VAR model
}
\description{
Estimation of a VAR using equation-by-equation OLS regressions.
}
\examples{
data(dy2012)
fit = VAR(dy2012, configuration=list(nlag=1))
}
\references{
Sims, C. A. (1980). Macroeconomics and reality. Econometrica, 1-48.
}
\author{
David Gabauer
}
