% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtendedJointConnectedness.R
\name{ExtendedJointConnectedness}
\alias{ExtendedJointConnectedness}
\title{Balcilar et al. (2021) extended joint connectedness approach}
\usage{
ExtendedJointConnectedness(Phi, Sigma, nfore = 10)
}
\arguments{
\item{Phi}{VAR coefficient matrix}

\item{Sigma}{Residual variance-covariance matrix}

\item{nfore}{H-step ahead forecast horizon}
}
\value{
Get connectedness measures
}
\description{
This function provides extended joint connectedness measures.
}
\examples{
\donttest{
#Replication of Balcilar et al. (2021)
data("bgu2021")
prior = MinnesotaPrior(0.1, k=ncol(bgu2021), nlag=1)
fit = TVPVAR(bgu2021, configuration=list(l=c(0.99,0.99), nlag=1, prior=prior))
dca = ExtendedJointConnectedness(Phi=fit$B_t, Sigma=fit$Q_t, nfore=20)
dca$TABLE
}
}
\references{
Balcilar, M., Gabauer, D., & Umar, Z. (2021). Crude Oil futures contracts and commodity markets: New evidence from a TVP-VAR extended joint connectedness approach. Resources Policy, 73, 102219.
}
\author{
David Gabauer
}
