% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpr_model.R
\name{BevertonHolt}
\alias{BevertonHolt}
\title{Beverton-Holt settler-recruit relationship}
\usage{
BevertonHolt(S, slope = 1/0.35, Rmax = 1)
}
\arguments{
\item{S}{a vector of settlement values, 1 for each site.}

\item{slope}{slope at the origin of the settler-recruit relationship.  Can be
a vector of same length as \code{S}.}

\item{Rmax}{maximum recruitment value.}
}
\value{
A vector of recruitment values.
}
\description{
Calculates recruitment based on the settler-recruit relationship from 
Beverton & Holt (1957): \code{ slope * settlers / (1+slope*settlers/Rmax) }
}
\details{
\code{slope} and \code{Rmax} can both either be scalars or vectors of the
same length as \code{S}.
}
\author{
David M. Kaplan \email{dmkaplan2000@gmail.com}
}
\references{
Beverton RJH, Holt SJ (1957) On the dynamics of exploited fish 
  populations. H.M.S.O., London. 533 pp.
}

