% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCEI.R
\name{SCEI}
\alias{SCEI}
\title{Standardized Compound Event Indicator (SCEI)}
\usage{
SCEI(mp,mt,ts)
}
\arguments{
\item{mp}{monthly precipitation}

\item{mt}{monthly temperature}

\item{ts}{time scale}
}
\value{
The monthly SCEI series
}
\description{
Compute SCEI based on monthly  precipitation and temperature.
}
\examples{
mp=matrix(rnorm(120,0,1),ncol=1)
mt=matrix(rnorm(120,0,1),ncol=1)
ts=3; # ts<=12 otherwise you should revise line 98
nd<-SCEI(mp,mt,ts)
d=cbind(mp,mt,nd)
testd<-matrix(d, ncol=3,byrow=FALSE)
}
\references{
Hao, Z. et al., 2019a. Statistical prediction of the severity of compound dry-hot events based on El Ni??o-Southern Oscillation. J. Hydrol., 572, 243-250.
}
