% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{print.compCL}
\alias{print.compCL}
\title{Print a \code{"compCL"} object.}
\usage{
\method{print}{compCL}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{x}{fitted \code{"\link{compCL}"} object.}

\item{digits}{significant digits in printout.}

\item{...}{not used.}
}
\value{
a two-column matrix; the first column \code{DF} gives the number of nonzero
coefficients for the compositional predictors and
the second column \code{Lam} gives the corresponding \code{lam} values.
}
\description{
print the number of nonzero coefficients for the compositional varaibles at each step along the compCL path.
}
\examples{
Comp_data = comp_Model(n = 50, p = 30)
Comp_fit = compCL(y = Comp_data$y, Z = Comp_data$X.comp,
                  Zc = Comp_data$Zc, intercept = Comp_data$intercept)
print(Comp_fit)

}
\references{
Lin, W., Shi, P., Peng, R. and Li, H. (2014) \emph{Variable selection in
regression with compositional covariates},
\href{https://academic.oup.com/biomet/article/101/4/785/1775476}{https://academic.oup.com/biomet/article/101/4/785/1775476}.
\emph{Biometrika} \strong{101} 785-979.
}
\seealso{
\code{\link{compCL}} and \code{\link[=coef.compCL]{coef}},
\code{\link[=predict.compCL]{predict}} and \code{\link[=plot.compCL]{plot}} methods
for \code{"compCL"} object.
}
\author{
Zhe Sun and Kun Chen
}
