% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{predict.FuncompCGL}
\alias{predict.FuncompCGL}
\title{Make prediction from a \code{"FuncompCGL"} object.}
\usage{
\method{predict}{FuncompCGL}(object, Znew, Zcnew = NULL, s = NULL,
        T.name = "TIME", ID.name = "Subject_ID",
        Trange, interval, insert, basis_fun, degree, method, sseq,
        ...)
}
\arguments{
\item{object}{fitted \code{\link{FuncompCGL}} object.}

\item{Znew}{data frame or matrix \code{X} as in \code{FuncompCGL} with new
functional compositional data at which prediction is to be made.}

\item{Zcnew}{matrix \code{Zc} as in \code{FuncompCGL} with new values of
time-invariate covariates at which prediction is to be made.
Default is \code{NULL}.}

\item{s}{value(s) of the penalty parameter \code{lam} at which predictions are requested.
Default is the entire sequence used to fit the model.}

\item{T.name}{a character string specifying names of the time variable and the Subject
ID variable in \code{X}.
This is only needed when X is a data frame or matrix of the functional
compositional predictors.
Default are \code{"TIME"} and \code{"Subject_ID"}.}

\item{ID.name}{a character string specifying names of the time variable and the Subject
ID variable in \code{X}.
This is only needed when X is a data frame or matrix of the functional
compositional predictors.
Default are \code{"TIME"} and \code{"Subject_ID"}.}

\item{Trange, interval, insert, basis_fun, degree, method}{the same as those in \code{FuncompCGL}.}

\item{sseq}{full set of potential time points of observations;
used for interpolation when \code{insert = "X"}
or \code{insert = "basis"}.}

\item{\dots}{not used.}
}
\value{
predicted values at the requested value(s) for \code{s}.
}
\description{
Make prediction based on a fitted \code{\link{FuncompCGL}} object.
}
\details{
\code{s} is the vector at which predictions are requested. If \code{s} is not in the \code{lam}
sequence used for fitting the model, the \code{predict} function uses linear interpolation.
\cr
If the data frame \code{X} is provided in \code{FuncompCGL} mode, the integral
for new data \code{newx} is taken the same as that in the fitted
\code{FuncompCGL} model. This means that the parameters \code{degree},
\code{basis_fun}, \code{insert}, \code{method}, \code{inteval},
\code{Trange}, and \code{K} are exactly the same as these in the provided
\code{object}. If \code{insert="X"} or \code{"basis"}, \code{sseq} is the
sorted sequence of all the observed time points in fitting \code{FuncompCGL} model and
all the observed time points in \code{newx}. Then interpolation is
conducted on \code{sseq}. If matrix \code{X} after integral is provided in
the \code{FuncompCGL} object, these parameters are required.
}
\examples{
p = 30
n_train = 50
n_test = 30
df_beta = 5
beta_C_true = matrix(0, nrow = p, ncol = df_beta)
beta_C_true[1, ] <- c(-0.5, -0.5, -0.5 , -1, -1)
beta_C_true[2, ] <- c(0.8, 0.8,  0.7,  0.6,  0.6)
beta_C_true[3, ] <- c(-0.8, -0.8 , 0.4 , 1 , 1)
beta_C_true[4, ] <- c(0.5, 0.5, -0.6  ,-0.6, -0.6)
Data <- Fcomp_Model(n = n_train, p = p, m = 0, intercept = TRUE,
                    SNR = 2, sigma = 2,
                    rho_X = 0, rho_T = 0.5, df_beta = df_beta,
                    n_T = 20, obs_spar = 1, theta.add = c(3,4,5),
                    beta_C = as.vector(t(beta_C_true)))
m1 <- FuncompCGL(y = Data$data$y, X = Data$data$Comp , Zc = Data$data$Zc,
                 intercept = Data$data$intercept, k = df_beta)
arg_list <- as.list(Data$call)[-1]
arg_list$n <- n_test
TEST <- do.call(Fcomp_Model, arg_list)
predmat <- predict(m1, Znew = TEST$data$Comp, Zcnew = TEST$data$Zc)
predmat <- predict(m1, Znew = TEST$data$Comp, Zcnew = TEST$data$Zc, s = c(0.5, 0.1, 0.05))

}
\references{
Sun, Z., Xu, W., Cong, X., Li G. and Chen K. (2020) \emph{Log-contrast regression with
functional compositional predictors: linking preterm infant's gut microbiome trajectories
to neurobehavioral outcome}, \href{https://arxiv.org/abs/1808.02403}{https://arxiv.org/abs/1808.02403}
\emph{Annals of Applied Statistics}
}
\seealso{
\code{\link{FuncompCGL}}, and \code{\link[=coef.FuncompCGL]{coef}},
\code{\link[=plot.FuncompCGL]{plot}} and \code{\link[=print.FuncompCGL]{print}}
methods for \code{"FuncompCGL"} object.
}
\author{
Zhe Sun and Kun Chen
}
