% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{plot.compCL}
\alias{plot.compCL}
\title{Plot solution paths from a \code{"compCL"} object.}
\usage{
\method{plot}{compCL}(x, xlab = c("lam", "norm"), label = FALSE, ...)
}
\arguments{
\item{x}{fitted \code{"\link{compCL}"} model.}

\item{xlab}{what is on the X-axis. \code{"lam"} plots against the log-lambda sequence
(default) and \code{"norm"} against the L1-norm of the coefficients.}

\item{label}{if TRUE, label the curve with the variable sequence numbers. Default is \code{FALSE}.}

\item{...}{other graphical parameters.}
}
\value{
No return value. Side effect is a base R plot.
}
\description{
Produce a coefficient profile plot from a fitted
\code{"\link{compCL}"} object.
}
\details{
A coefficient profile plot for the compositional predictors is produced.
}
\examples{
Comp_data = comp_Model(n = 50, p = 30)
Comp_fit = compCL(y = Comp_data$y, Z = Comp_data$X.comp, Zc = Comp_data$Zc,
                  intercept = Comp_data$intercept)
plot(Comp_fit)
plot(Comp_fit, xlab = "norm", label = TRUE)

}
\references{
Lin, W., Shi, P., Peng, R. and Li, H. (2014) \emph{Variable selection in
regression with compositional covariates},
\href{https://academic.oup.com/biomet/article/101/4/785/1775476}{https://academic.oup.com/biomet/article/101/4/785/1775476}.
\emph{Biometrika} \strong{101} 785-979.
}
\seealso{
\code{\link{compCL}} and \code{\link[=print.compCL]{print}},
\code{\link[=predict.compCL]{predict}} and \code{\link[=coef.compCL]{coef}} methods
for \code{"compCL"} object.
}
\author{
Zhe Sun and Kun Chen
}
