% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/environment_mix_lib_package.R
\name{lmi_simul_dat}
\alias{lmi_simul_dat}
\title{Simulate data from linear model with interactions}
\usage{
lmi_simul_dat(
  n,
  p,
  q,
  block_idx = c(1, 1, 2, 2, 3, 1, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3),
  sigma2_x = 1,
  within_rho = 0.6,
  btw_rho = 0.2,
  R2 = 0.8,
  effect_size = 1,
  effect_size_i = 1,
  cancel_effect = TRUE
)
}
\arguments{
\item{n}{a positive integer to indicate sample size}

\item{p}{a positive integer to specify the number of exposures}

\item{q}{a positive integer to specify the number of non-zero effects}

\item{block_idx}{a vector of positive integers to indicate the block IDs.
The length of the vector is p.}

\item{sigma2_x}{a positive numeric scalar for variance of the covariates}

\item{within_rho}{a numeric scalar between 0 and 1 for the within block correlation}

\item{btw_rho}{a numeric scalar between 0 and 1 for the between block correlation}

\item{R2}{a numeric scalar for R-squared}

\item{effect_size}{a numeric scalar for effect size for main effect}

\item{effect_size_i}{a numeric scalar for effect size for interaction effect}

\item{cancel_effect}{a logic value to indicate whether there is effect cancelation}
}
\value{
a list object of the following
\describe{
\item{x}{covariate matrix of dimension n by p}
\item{n}{sample size}
\item{p}{number of covariates}
\item{sigma2_x}{variance}
\item{within_rho}{within block correlation}
\item{btw_rho}{between block correaltion}
\item{block_idx}{block indices}
}
}
\description{
Simulate data from linear model with interactions
}
\author{
Wei Hao <weihao@umich.edu>
}
