/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine;

import org.rosuda.REngine.REXPList;
import org.rosuda.REngine.REXPVector;

public class REXPDouble
extends REXPVector {
    private double[] payload;
    public static final double NA = Double.longBitsToDouble(9218868437227407266L);
    static final long NA_bits = Double.doubleToRawLongBits(Double.longBitsToDouble(9218868437227407266L));

    public static boolean isNA(double d) {
        return (Double.doubleToRawLongBits(d) & 0xFFF7FFFFFFFFFFFFL) == (NA_bits & 0xFFF7FFFFFFFFFFFFL);
    }

    public REXPDouble(double d) {
        this.payload = new double[]{d};
    }

    public REXPDouble(double[] dArray) {
        this.payload = dArray == null ? new double[]{} : dArray;
    }

    public REXPDouble(double[] dArray, REXPList rEXPList) {
        super(rEXPList);
        this.payload = dArray == null ? new double[]{} : dArray;
    }

    public int length() {
        return this.payload.length;
    }

    public Object asNativeJavaObject() {
        return this.payload;
    }

    public boolean isNumeric() {
        return true;
    }

    public double[] asDoubles() {
        return this.payload;
    }

    public int[] asIntegers() {
        int[] nArray = new int[this.payload.length];
        for (int i = 0; i < this.payload.length; ++i) {
            nArray[i] = (int)this.payload[i];
        }
        return nArray;
    }

    public String[] asStrings() {
        String[] stringArray = new String[this.payload.length];
        for (int i = 0; i < this.payload.length; ++i) {
            stringArray[i] = "" + this.payload[i];
        }
        return stringArray;
    }

    public boolean[] isNA() {
        boolean[] blArray = new boolean[this.payload.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = REXPDouble.isNA(this.payload[i]);
        }
        return blArray;
    }

    public String toDebugString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(super.toDebugString() + "{");
        for (n = 0; n < this.payload.length && n < maxDebugItems; ++n) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.payload[n]);
        }
        if (n < this.payload.length) {
            stringBuffer.append(",..");
        }
        return stringBuffer.toString() + "}";
    }
}

