/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.shaped.panel;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Shape;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import net.infonode.gui.BackgroundPainter;
import net.infonode.gui.InsetsUtil;
import net.infonode.gui.componentpainter.ComponentPainter;
import net.infonode.gui.panel.BaseContainer;
import net.infonode.gui.shaped.border.ShapedBorder;
import net.infonode.util.Direction;

public class ShapedPanel
extends BaseContainer
implements BackgroundPainter {
    private Direction direction = Direction.RIGHT;
    private boolean horizontalFlip;
    private boolean verticalFlip;
    private boolean clipChildren;
    private ComponentPainter painter;
    private ShapedBorder shapedBorder;
    private Insets shapedInsets;

    public ShapedPanel() {
    }

    public ShapedPanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public ShapedPanel(ComponentPainter componentPainter) {
        this();
        this.painter = componentPainter;
    }

    public ShapedPanel(ComponentPainter componentPainter, Border border) {
        this(componentPainter);
        this.setBorder(border);
    }

    public ShapedPanel(Component component) {
        this();
        this.add(component, "Center");
    }

    public Shape getShape() {
        ShapedBorder shapedBorder = this.getShapedBorder();
        return shapedBorder == null ? null : shapedBorder.getShape(this, this.shapedInsets.left, this.shapedInsets.top, this.getWidth() - this.shapedInsets.left - this.shapedInsets.right, this.getHeight() - this.shapedInsets.top - this.shapedInsets.bottom);
    }

    public ComponentPainter getComponentPainter() {
        return this.painter;
    }

    public void setComponentPainter(ComponentPainter componentPainter) {
        if (this.painter != componentPainter) {
            this.painter = componentPainter;
            this.repaint();
        }
    }

    public Direction getDirection() {
        return this.direction;
    }

    public boolean isHorizontalFlip() {
        return this.horizontalFlip;
    }

    public void setHorizontalFlip(boolean bl) {
        if (this.horizontalFlip != bl) {
            this.horizontalFlip = bl;
            this.revalidate();
        }
    }

    public boolean isVerticalFlip() {
        return this.verticalFlip;
    }

    public void setVerticalFlip(boolean bl) {
        if (this.verticalFlip != bl) {
            this.verticalFlip = bl;
            this.revalidate();
        }
    }

    public void setDirection(Direction direction) {
        if (this.direction != direction) {
            this.direction = direction;
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isClipChildren() {
        return this.clipChildren;
    }

    public void setClipChildren(boolean bl) {
        this.clipChildren = bl;
    }

    public ShapedBorder getShapedBorder() {
        return this.shapedBorder;
    }

    public void setBorder(Border border) {
        super.setBorder(border);
        this.shapedBorder = null;
        this.findShapedBorder(this.getBorder(), new Insets(0, 0, 0, 0));
    }

    protected void paintChildren(Graphics graphics) {
        Shape shape;
        if (this.clipChildren && (shape = this.getShape()) != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Shape shape2 = graphics2D.getClip();
            graphics2D.clip(shape);
            super.paintChildren(graphics);
            graphics2D.setClip(shape2);
            return;
        }
        super.paintChildren(graphics);
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.painter != null) {
            Shape shape = this.getShape();
            if (shape != null) {
                Shape shape2 = graphics.getClip();
                graphics.clipRect(this.shapedInsets.left, this.shapedInsets.top, this.getWidth() - this.shapedInsets.left - this.shapedInsets.right, this.getHeight() - this.shapedInsets.top - this.shapedInsets.bottom);
                ((Graphics2D)graphics).clip(shape);
                this.painter.paint(this, graphics, 0, 0, this.getWidth(), this.getHeight(), this.direction, this.horizontalFlip, this.verticalFlip);
                graphics.setClip(shape2);
            } else {
                this.painter.paint(this, graphics, 0, 0, this.getWidth(), this.getHeight(), this.direction, this.horizontalFlip, this.verticalFlip);
            }
        }
    }

    public boolean contains(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.getWidth() || n2 >= this.getHeight()) {
            return false;
        }
        Shape shape = this.getShape();
        return shape == null ? super.contains(n, n2) : shape.contains(n, n2);
    }

    public boolean inside(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.getWidth() || n2 >= this.getHeight()) {
            return false;
        }
        Shape shape = this.getShape();
        return shape == null ? super.inside(n, n2) : shape.contains(n, n2);
    }

    private boolean findShapedBorder(Border border, Insets insets) {
        if (border == null) {
            return false;
        }
        if (border instanceof ShapedBorder) {
            this.shapedBorder = (ShapedBorder)border;
            this.shapedInsets = insets;
            return true;
        }
        if (border instanceof CompoundBorder) {
            CompoundBorder compoundBorder = (CompoundBorder)border;
            if (this.findShapedBorder(compoundBorder.getOutsideBorder(), insets)) {
                return true;
            }
            return this.findShapedBorder(compoundBorder.getInsideBorder(), InsetsUtil.add(compoundBorder.getOutsideBorder().getBorderInsets(this), insets));
        }
        return false;
    }
}

