/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.infonode.docking.AbstractTabWindow;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.RootWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.WindowTab;
import net.infonode.docking.drag.DockingWindowDragSource;
import net.infonode.docking.drag.DockingWindowDragger;
import net.infonode.docking.drag.DockingWindowDraggerProvider;
import net.infonode.docking.drop.InteriorDropInfo;
import net.infonode.docking.internal.ReadContext;
import net.infonode.docking.internal.ViewTitleBar;
import net.infonode.docking.internal.WriteContext;
import net.infonode.docking.internalutil.DropAction;
import net.infonode.docking.model.ViewItem;
import net.infonode.docking.model.ViewWriter;
import net.infonode.docking.properties.ViewProperties;
import net.infonode.docking.properties.ViewTitleBarProperties;
import net.infonode.gui.ComponentUtil;
import net.infonode.gui.panel.SimplePanel;
import net.infonode.properties.base.Property;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapWeakListenerManager;
import net.infonode.properties.util.PropertyChangeListener;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.util.ChangeNotifyList;
import net.infonode.util.Direction;
import net.infonode.util.StreamUtil;

public class View
extends DockingWindow {
    private Component lastFocusedComponent;
    private HierarchyListener focusComponentListener = new HierarchyListener(){

        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            View.this.checkLastFocusedComponent();
        }
    };
    private SimplePanel contentPanel = new SimplePanel();
    private ViewProperties rootProperties = new ViewProperties();
    private WeakReference lastRootWindow;
    private PropertyChangeListener listener = new PropertyChangeListener(){

        public void propertyChanged(Property property, Object object, Object object2, Object object3) {
            View.this.fireTitleChanged();
        }
    };
    private PropertyChangeListener titleBarPropertiesListener = new PropertyChangeListener(){

        public void propertyChanged(Property property, Object object, Object object2, Object object3) {
            View.this.updateTitleBar(property, object);
        }
    };
    private ViewTitleBar titleBar;
    private boolean isfocused = false;
    private List customTitleBarComponents;
    private WindowTab ghostTab;
    private DropAction titleBarDropAction = new DropAction(){

        public boolean showTitle() {
            return false;
        }

        public void execute(DockingWindow dockingWindow, MouseEvent mouseEvent) {
            this.removeGhostTab();
            ((AbstractTabWindow)View.this.getWindowParent()).addTab(dockingWindow);
        }

        public void clear(DockingWindow dockingWindow, DropAction dropAction) {
            if (dropAction != this) {
                this.removeGhostTab();
            }
        }

        private void removeGhostTab() {
            if (View.this.ghostTab != null) {
                TabbedPanel tabbedPanel = ((AbstractTabWindow)View.this.getWindowParent()).getTabbedPanel();
                tabbedPanel.removeTab(View.this.ghostTab);
                View.this.ghostTab = null;
                if (tabbedPanel.getProperties().getEnsureSelectedTabVisible() && tabbedPanel.getSelectedTab() != null) {
                    tabbedPanel.scrollTabToVisibleArea(tabbedPanel.getSelectedTab());
                }
            }
        }
    };
    static /* synthetic */ Class class$net$infonode$docking$View;

    public View(String string, Icon icon, Component component) {
        super(new ViewItem());
        this.rootProperties.setTitle(string);
        this.rootProperties.setIcon(icon);
        this.getViewProperties().addSuperObject(this.rootProperties);
        super.setComponent(this.contentPanel);
        this.contentPanel.setComponent(component);
        PropertyMapWeakListenerManager.addWeakPropertyChangeListener(this.getViewProperties().getMap(), ViewProperties.TITLE, this.listener);
        PropertyMapWeakListenerManager.addWeakPropertyChangeListener(this.getViewProperties().getMap(), ViewProperties.ICON, this.listener);
        PropertyMapWeakListenerManager.addWeakPropertyChangeListener(this.getViewProperties().getViewTitleBarProperties().getMap(), ViewTitleBarProperties.VISIBLE, this.titleBarPropertiesListener);
        PropertyMapWeakListenerManager.addWeakPropertyChangeListener(this.getViewProperties().getViewTitleBarProperties().getMap(), ViewTitleBarProperties.CONTENT_TITLE_BAR_GAP, this.titleBarPropertiesListener);
        PropertyMapWeakListenerManager.addWeakPropertyChangeListener(this.getViewProperties().getViewTitleBarProperties().getMap(), ViewTitleBarProperties.ORIENTATION, this.titleBarPropertiesListener);
        this.updateTitleBar(null, null);
        this.init();
    }

    public List getCustomTabComponents() {
        return this.getTab().getCustomTabComponentsList();
    }

    public List getCustomTitleBarComponents() {
        if (this.customTitleBarComponents == null) {
            this.customTitleBarComponents = new ChangeNotifyList(){

                protected void changed() {
                    if (View.this.titleBar != null) {
                        View.this.titleBar.updateCustomBarComponents(this);
                    }
                }
            };
        }
        return this.customTitleBarComponents;
    }

    public Component getComponent() {
        return this.contentPanel.getComponent(0);
    }

    public void setComponent(Component component) {
        this.contentPanel.setComponent(component);
    }

    public ViewProperties getViewProperties() {
        return ((ViewItem)this.getWindowItem()).getViewProperties();
    }

    protected void update() {
    }

    public DockingWindow getChildWindow(int n) {
        return null;
    }

    public int getChildWindowCount() {
        return 0;
    }

    void setLastFocusedComponent(Component component) {
        if (component != this.lastFocusedComponent) {
            if (this.lastFocusedComponent != null) {
                this.lastFocusedComponent.removeHierarchyListener(this.focusComponentListener);
            }
            this.lastFocusedComponent = component;
            if (this.lastFocusedComponent != null) {
                this.lastFocusedComponent.addHierarchyListener(this.focusComponentListener);
            }
        }
    }

    Component getFocusComponent() {
        this.checkLastFocusedComponent();
        return this.lastFocusedComponent;
    }

    public boolean isFocusCycleRoot() {
        return true;
    }

    public void restoreFocus() {
        this.makeVisible();
        this.checkLastFocusedComponent();
        if (this.lastFocusedComponent == null) {
            ComponentUtil.smartRequestFocus(this.contentPanel);
        } else {
            this.lastFocusedComponent.requestFocusInWindow();
        }
    }

    public Icon getIcon() {
        return this.getViewProperties().getIcon();
    }

    protected void doReplace(DockingWindow dockingWindow, DockingWindow dockingWindow2) {
        throw new RuntimeException((class$net$infonode$docking$View == null ? (class$net$infonode$docking$View = View.class$("net.infonode.docking.View")) : class$net$infonode$docking$View) + ".replaceChildWindow called!");
    }

    protected void doRemoveWindow(DockingWindow dockingWindow) {
        throw new RuntimeException((class$net$infonode$docking$View == null ? (class$net$infonode$docking$View = View.class$("net.infonode.docking.View")) : class$net$infonode$docking$View) + ".removeChildWindow called!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(ObjectOutputStream objectOutputStream, WriteContext writeContext) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream2 = new ObjectOutputStream(byteArrayOutputStream);
        try {
            writeContext.getViewSerializer().writeView(this, objectOutputStream2);
            this.getWindowItem().writeSettings(objectOutputStream2, writeContext);
        }
        finally {
            objectOutputStream2.close();
        }
        objectOutputStream.writeInt(byteArrayOutputStream.size());
        byteArrayOutputStream.writeTo(objectOutputStream);
    }

    static View read(ObjectInputStream objectInputStream, ReadContext readContext) throws IOException {
        int n = objectInputStream.readInt();
        byte[] byArray = new byte[n];
        StreamUtil.readAll(objectInputStream, byArray);
        ObjectInputStream objectInputStream2 = new ObjectInputStream(new ByteArrayInputStream(byArray));
        View view = readContext.getViewSerializer().readView(objectInputStream2);
        if (view != null) {
            view.getWindowItem().readSettings(objectInputStream2, readContext);
        }
        return view;
    }

    protected DropAction doAcceptDrop(Point point, DockingWindow dockingWindow) {
        if (this.getWindowParent() instanceof TabWindow && this.titleBar != null && this.titleBar.contains(SwingUtilities.convertPoint(this, point, this.titleBar))) {
            return this.acceptInteriorDrop(point, dockingWindow);
        }
        return this.getWindowParent() instanceof TabWindow && this.getWindowParent().getChildWindowCount() == 1 ? null : super.doAcceptDrop(point, dockingWindow);
    }

    protected DropAction acceptInteriorDrop(Point point, DockingWindow dockingWindow) {
        Point point2;
        if (this.getWindowParent() instanceof TabWindow && this.titleBar != null && dockingWindow.getWindowParent() != this.getWindowParent() && this.titleBar.contains(point2 = SwingUtilities.convertPoint(this, point, this.titleBar))) {
            if (!this.getInteriorDropFilter().acceptDrop(new InteriorDropInfo(dockingWindow, this, point))) {
                return null;
            }
            this.addGhostTab(dockingWindow);
            DockingWindow dockingWindow2 = this.getWindowParent() instanceof TabWindow ? this.getWindowParent() : this;
            this.getRootWindow().setDragRectangle(SwingUtilities.convertRectangle(dockingWindow2, new Rectangle(0, 0, ((Component)dockingWindow2).getWidth(), ((Component)dockingWindow2).getHeight()), this.getRootWindow()));
            return this.titleBarDropAction;
        }
        return null;
    }

    private void addGhostTab(DockingWindow dockingWindow) {
        if (this.ghostTab == null) {
            this.ghostTab = ((AbstractTabWindow)this.getWindowParent()).createGhostTab(dockingWindow);
            ((AbstractTabWindow)this.getWindowParent()).getTabbedPanel().addTab(this.ghostTab);
            ((AbstractTabWindow)this.getWindowParent()).getTabbedPanel().scrollTabToVisibleArea(this.ghostTab);
        }
    }

    public String toString() {
        return this.getTitle();
    }

    void setRootWindow(RootWindow rootWindow) {
        RootWindow rootWindow2;
        if (rootWindow == null) {
            return;
        }
        RootWindow rootWindow3 = rootWindow2 = this.lastRootWindow == null ? null : (RootWindow)this.lastRootWindow.get();
        if (rootWindow2 == rootWindow) {
            return;
        }
        if (rootWindow2 != null) {
            rootWindow2.removeView(this);
        }
        this.lastRootWindow = new WeakReference<RootWindow>(rootWindow);
        rootWindow.addView(this);
    }

    protected void setFocused(boolean bl) {
        super.setFocused(bl);
        if (this.isfocused != bl) {
            this.isfocused = bl;
            if (bl) {
                this.getViewProperties().getViewTitleBarProperties().getNormalProperties().addSuperObject(this.getViewProperties().getViewTitleBarProperties().getFocusedProperties());
            } else {
                this.getViewProperties().getViewTitleBarProperties().getNormalProperties().removeSuperObject(this.getViewProperties().getViewTitleBarProperties().getFocusedProperties());
            }
        }
    }

    protected void rootChanged(RootWindow rootWindow, RootWindow rootWindow2) {
        super.rootChanged(rootWindow, rootWindow2);
        this.setRootWindow(rootWindow2);
        if (rootWindow != this.getRootWindow()) {
            if (rootWindow != null) {
                this.rootProperties.removeSuperObject(rootWindow.getRootWindowProperties().getViewProperties());
            }
            if (this.getRootWindow() != null) {
                this.rootProperties.addSuperObject(this.getRootWindow().getRootWindowProperties().getViewProperties());
            }
        }
    }

    protected PropertyMap getPropertyObject() {
        return this.getViewProperties().getMap();
    }

    protected PropertyMap createPropertyObject() {
        return new ViewProperties().getMap();
    }

    protected boolean needsTitleWindow() {
        return this.getViewProperties().getAlwaysShowTitle();
    }

    private void checkLastFocusedComponent() {
        if (this.lastFocusedComponent != null && !SwingUtilities.isDescendingFrom(this.lastFocusedComponent, this)) {
            this.lastFocusedComponent.removeHierarchyListener(this.focusComponentListener);
            this.lastFocusedComponent = null;
        }
    }

    void removeWindowComponent(DockingWindow dockingWindow) {
    }

    void restoreWindowComponent(DockingWindow dockingWindow) {
    }

    private void updateTitleBar(Property property, Object object) {
        boolean bl = object == null;
        ViewTitleBarProperties viewTitleBarProperties = this.getViewProperties().getViewTitleBarProperties();
        if (bl || property == ViewTitleBarProperties.VISIBLE) {
            if (viewTitleBarProperties.getVisible()) {
                if (this.titleBar == null) {
                    this.titleBar = new ViewTitleBar(this);
                    new DockingWindowDragSource(this.titleBar, new DockingWindowDraggerProvider(){

                        public DockingWindowDragger getDragger(MouseEvent mouseEvent) {
                            return View.this.getWindowProperties().getDragEnabled() ? View.this.startDrag(View.this.getRootWindow()) : null;
                        }
                    });
                    this.titleBar.addMouseListener(new MouseAdapter(){

                        public void mousePressed(MouseEvent mouseEvent) {
                            View.this.fireTabWindowMouseButtonEvent(mouseEvent);
                            this.checkPopupMenu(mouseEvent);
                        }

                        public void mouseClicked(MouseEvent mouseEvent) {
                            View.this.fireTabWindowMouseButtonEvent(mouseEvent);
                        }

                        public void mouseReleased(MouseEvent mouseEvent) {
                            View.this.fireTabWindowMouseButtonEvent(mouseEvent);
                            this.checkPopupMenu(mouseEvent);
                        }

                        private void checkPopupMenu(MouseEvent mouseEvent) {
                            if (mouseEvent.isPopupTrigger()) {
                                View.this.showPopupMenu(mouseEvent);
                            }
                        }
                    });
                    if (this.customTitleBarComponents != null) {
                        this.titleBar.updateCustomBarComponents(this.customTitleBarComponents);
                    }
                    bl = true;
                }
            } else if (this.titleBar != null) {
                this.remove(this.titleBar);
                this.titleBar.dispose();
                this.titleBar = null;
                bl = true;
            }
        }
        if ((bl || property == ViewTitleBarProperties.ORIENTATION) && this.titleBar != null) {
            this.remove(this.titleBar);
            this.add((Component)this.titleBar, ComponentUtil.getBorderLayoutOrientation(viewTitleBarProperties.getOrientation()));
            bl = true;
        }
        if (bl || property == ViewTitleBarProperties.CONTENT_TITLE_BAR_GAP) {
            if (this.titleBar != null) {
                Direction direction = viewTitleBarProperties.getOrientation();
                int n = viewTitleBarProperties.getContentTitleBarGap();
                this.contentPanel.setBorder(new EmptyBorder(direction == Direction.UP ? n : 0, direction == Direction.LEFT ? n : 0, direction == Direction.DOWN ? n : 0, direction == Direction.RIGHT ? n : 0));
            } else {
                this.contentPanel.setBorder(null);
            }
        }
    }

    protected void updateButtonVisibility() {
        super.updateButtonVisibility();
        if (this.titleBar != null) {
            this.titleBar.updateViewButtons(null);
        }
    }

    protected void write(ObjectOutputStream objectOutputStream, WriteContext writeContext, ViewWriter viewWriter) throws IOException {
        objectOutputStream.writeInt(1);
        viewWriter.writeView(this, objectOutputStream, writeContext);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

