/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.border.Border;
import net.infonode.gui.GraphicsUtil;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.colorprovider.ColorProviderList;
import net.infonode.gui.colorprovider.ColorProviderUtil;
import net.infonode.gui.colorprovider.FixedColorProvider;
import net.infonode.gui.colorprovider.UIManagerColorProvider;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.tabbedpanel.TabbedUtils;
import net.infonode.util.Direction;

public class TabAreaLineBorder
implements Border,
Serializable {
    private static final long serialVersionUID = 1L;
    private ColorProvider color;
    private boolean drawTop;
    private boolean drawLeft;
    private boolean drawRight;
    private boolean flipLeftRight;

    public TabAreaLineBorder() {
        this(null);
    }

    public TabAreaLineBorder(Color color) {
        this(color, true, true, true, false);
    }

    public TabAreaLineBorder(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this((Color)null, bl, bl2, bl3, bl4);
    }

    public TabAreaLineBorder(Color color, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(ColorProviderUtil.getColorProvider(color, new ColorProviderList(UIManagerColorProvider.TABBED_PANE_DARK_SHADOW, UIManagerColorProvider.CONTROL_DARK_SHADOW, FixedColorProvider.BLACK)), bl, bl2, bl3, bl4);
    }

    public TabAreaLineBorder(ColorProvider colorProvider, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.color = colorProvider;
        this.drawTop = bl;
        this.drawLeft = bl2;
        this.drawRight = bl3;
        this.flipLeftRight = bl4;
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Insets insets = this.getBorderInsets(component);
        graphics.setColor(this.color.getColor(component));
        if (insets.top == 1) {
            GraphicsUtil.drawOptimizedLine(graphics, n, n2, n + n3 - 1, n2);
        }
        if (insets.bottom == 1) {
            GraphicsUtil.drawOptimizedLine(graphics, n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        }
        if (insets.left == 1) {
            GraphicsUtil.drawOptimizedLine(graphics, n, n2, n, n2 + n4 - 1);
        }
        if (insets.right == 1) {
            GraphicsUtil.drawOptimizedLine(graphics, n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
        }
    }

    private boolean drawTop(Direction direction) {
        return direction == Direction.UP ? this.drawTop : (direction == Direction.LEFT ? (this.flipLeftRight ? this.drawLeft : this.drawRight) : (direction == Direction.RIGHT ? this.drawLeft : false));
    }

    private boolean drawLeft(Direction direction) {
        return direction == Direction.UP ? this.drawLeft : (direction == Direction.LEFT ? this.drawTop : (direction == Direction.DOWN ? (this.flipLeftRight ? this.drawLeft : this.drawRight) : false));
    }

    private boolean drawRight(Direction direction) {
        return direction == Direction.UP ? this.drawRight : (direction == Direction.LEFT ? false : (direction == Direction.DOWN ? (this.flipLeftRight ? this.drawRight : this.drawLeft) : this.drawTop));
    }

    private boolean drawBottom(Direction direction) {
        return direction == Direction.UP ? false : (direction == Direction.LEFT ? (this.flipLeftRight ? this.drawRight : this.drawLeft) : (direction == Direction.RIGHT ? this.drawRight : this.drawTop));
    }

    public Insets getBorderInsets(Component component) {
        if (component instanceof JComponent && ((JComponent)component).getComponentCount() == 0) {
            return new Insets(0, 0, 0, 0);
        }
        Direction direction = TabAreaLineBorder.getTabAreaDirection(component);
        return direction != null ? new Insets(this.drawTop(direction) ? 1 : 0, this.drawLeft(direction) ? 1 : 0, this.drawBottom(direction) ? 1 : 0, this.drawRight(direction) ? 1 : 0) : new Insets(0, 0, 0, 0);
    }

    private static Direction getTabAreaDirection(Component component) {
        TabbedPanel tabbedPanel = TabbedUtils.getParentTabbedPanel(component);
        return tabbedPanel != null ? tabbedPanel.getProperties().getTabAreaOrientation() : null;
    }
}

