/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import net.infonode.gui.ComponentPaintChecker;
import net.infonode.gui.InsetsUtil;
import net.infonode.gui.RotatableLabel;
import net.infonode.gui.hover.panel.HoverableShapedPanel;
import net.infonode.util.Alignment;
import net.infonode.util.Direction;

public class ContentTitleBar
extends HoverableShapedPanel {
    private final ComponentPaintChecker repaintChecker;
    private JComponent[] leftTitleComponents;
    private JComponent[] rightTitleComponents;
    private Insets[] leftTitleComponentsInsets;
    private Insets[] rightTitleComponentsInsets;
    private boolean flipTitleComponents = false;
    private GridBagConstraints constraints = new GridBagConstraints();
    private Insets labelInsets = InsetsUtil.EMPTY_INSETS;
    private Alignment labelAlignment = Alignment.LEFT;
    private final RotatableLabel label = new RotatableLabel(""){

        public Dimension getMinimumSize() {
            Dimension dimension = super.getMinimumSize();
            if (this.getDirection().isHorizontal()) {
                return new Dimension(0, dimension.height);
            }
            return new Dimension(dimension.width, 0);
        }
    };

    public ContentTitleBar() {
        this((Component)null);
    }

    public ContentTitleBar(Component component) {
        super(new GridBagLayout(), null, component);
        this.repaintChecker = new ComponentPaintChecker(this);
        this.add(this.label);
        this.updateLayout();
    }

    public JLabel getLabel() {
        return this.label;
    }

    public String getText() {
        return this.label.getText();
    }

    public Icon getIcon() {
        return this.label.getIcon();
    }

    public void setIcon(Icon icon) {
        if (this.label.getIcon() != icon) {
            this.label.setIcon(icon);
            this.doUpdate();
        }
    }

    public Alignment getLabelAlignment() {
        return this.labelAlignment;
    }

    public void setLabelAlignment(Alignment alignment) {
        if (this.labelAlignment != alignment) {
            this.labelAlignment = alignment;
            this.updateLabelAlignment();
        }
    }

    public void setLayoutDirection(Direction direction) {
        if (this.label.getDirection() != direction) {
            this.label.setDirection(direction);
            this.updateLayout();
        }
    }

    public Insets getLabelInsets() {
        return this.labelInsets;
    }

    public void setLabelInsets(Insets insets) {
        this.labelInsets = insets;
        GridBagConstraints gridBagConstraints = ((GridBagLayout)this.getLayout()).getConstraints(this.label);
        gridBagConstraints.insets = InsetsUtil.rotate(this.getDirection(), insets);
        ((GridBagLayout)this.getLayout()).setConstraints(this.label, gridBagConstraints);
        this.doUpdate();
    }

    public boolean isFlipTitleComponents() {
        return this.flipTitleComponents;
    }

    public void setFlipTitleComponents(boolean bl) {
        if (this.flipTitleComponents != bl) {
            this.flipTitleComponents = bl;
            this.updateLayout();
        }
    }

    public JComponent[] getLeftTitleComponents() {
        return this.leftTitleComponents;
    }

    public void setLeftTitleComponents(JComponent[] jComponentArray) {
        this.setLeftTitleComponents(jComponentArray, jComponentArray == null ? null : this.createEmptyInsets(jComponentArray.length));
    }

    public void setLeftTitleComponents(JComponent[] jComponentArray, Insets[] insetsArray) {
        JComponent[] jComponentArray2 = this.leftTitleComponents;
        this.leftTitleComponents = jComponentArray;
        this.leftTitleComponentsInsets = insetsArray;
        this.updateTitleComponents(jComponentArray2, jComponentArray);
    }

    public JComponent[] getRightTitleComponents() {
        return this.rightTitleComponents;
    }

    public void setRightTitleComponents(JComponent[] jComponentArray) {
        this.setRightTitleComponents(jComponentArray, jComponentArray == null ? null : this.createEmptyInsets(jComponentArray.length));
    }

    public void setRightTitleComponents(JComponent[] jComponentArray, Insets[] insetsArray) {
        JComponent[] jComponentArray2 = this.rightTitleComponents;
        this.rightTitleComponents = jComponentArray;
        this.rightTitleComponentsInsets = insetsArray;
        this.updateTitleComponents(jComponentArray2, jComponentArray);
    }

    private Insets[] createEmptyInsets(int n) {
        Insets[] insetsArray = new Insets[n];
        for (int i = 0; i < n; ++i) {
            insetsArray[i] = InsetsUtil.EMPTY_INSETS;
        }
        return insetsArray;
    }

    private void updateLabelAlignment() {
        this.label.setHorizontalAlignment(this.labelAlignment == Alignment.LEFT ? 2 : (this.labelAlignment == Alignment.RIGHT ? 4 : 0));
    }

    private void updateTitleComponents(JComponent[] jComponentArray, JComponent[] jComponentArray2) {
        int n;
        if (jComponentArray != null) {
            for (n = 0; n < jComponentArray.length; ++n) {
                this.remove(jComponentArray[n]);
            }
        }
        if (jComponentArray2 != null) {
            for (n = 0; n < jComponentArray2.length; ++n) {
                this.add(jComponentArray2[n]);
            }
        }
        this.updateLayout();
    }

    private void updateLayout() {
        Insets[] insetsArray;
        Direction direction = this.label.getDirection();
        this.constraints = new GridBagConstraints();
        JComponent[] jComponentArray = this.flipTitleComponents ? this.rightTitleComponents : this.leftTitleComponents;
        JComponent[] jComponentArray2 = this.flipTitleComponents ? this.leftTitleComponents : this.rightTitleComponents;
        Insets[] insetsArray2 = this.flipTitleComponents ? this.rightTitleComponentsInsets : this.leftTitleComponentsInsets;
        Insets[] insetsArray3 = insetsArray = this.flipTitleComponents ? this.leftTitleComponentsInsets : this.rightTitleComponentsInsets;
        if (direction == Direction.LEFT || direction == Direction.UP) {
            JComponent[] jComponentArray3 = jComponentArray;
            jComponentArray = jComponentArray2;
            jComponentArray2 = jComponentArray3;
            Insets[] insetsArray4 = insetsArray2;
            insetsArray2 = insetsArray;
            insetsArray = insetsArray4;
        }
        if (direction.isHorizontal()) {
            int n;
            int n2 = 0;
            if (jComponentArray != null) {
                for (int i = 0; i < jComponentArray.length; ++i) {
                    n = direction == Direction.RIGHT ? i : jComponentArray.length - i - 1;
                    this.setConstraints(jComponentArray[n], insetsArray2[n], n2++, 0, 1, 1, 0, 0.0, 0.0, 10);
                }
            }
            this.setConstraints(this.label, this.labelInsets, n2++, 0, 1, 1, 1, 1.0, 1.0, 10);
            if (jComponentArray2 != null) {
                for (int i = 0; i < jComponentArray2.length; ++i) {
                    n = direction == Direction.RIGHT ? i : jComponentArray2.length - i - 1;
                    this.setConstraints(jComponentArray2[n], insetsArray[n], n2++, 0, 1, 1, 0, 0.0, 0.0, 10);
                }
            }
        } else {
            int n;
            int n3 = 0;
            if (jComponentArray != null) {
                for (int i = 0; i < jComponentArray.length; ++i) {
                    n = direction == Direction.DOWN ? i : jComponentArray.length - i - 1;
                    this.setConstraints(jComponentArray[n], insetsArray2[n], 0, n3++, 1, 1, 0, 0.0, 0.0, 10);
                }
            }
            this.setConstraints(this.label, this.labelInsets, 0, n3++, 1, 1, 1, 1.0, 1.0, 10);
            if (jComponentArray2 != null) {
                for (int i = 0; i < jComponentArray2.length; ++i) {
                    n = direction == Direction.DOWN ? i : jComponentArray2.length - i - 1;
                    this.setConstraints(jComponentArray2[n], insetsArray[n], 0, n3++, 1, 1, 0, 0.0, 0.0, 10);
                }
            }
        }
        this.doUpdate();
    }

    private void setConstraints(Component component, Insets insets, int n, int n2, int n3, int n4, int n5, double d, double d2, int n6) {
        this.constraints.insets = InsetsUtil.rotate(this.getDirection(), insets);
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.fill = n5;
        this.constraints.weightx = d;
        this.constraints.weighty = d2;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        this.constraints.anchor = n6;
        ((GridBagLayout)this.getLayout()).setConstraints(component, this.constraints);
    }

    private void doUpdate() {
        this.revalidate();
        if (this.repaintChecker.isPaintingOk()) {
            this.repaint();
        }
    }
}

