% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age_shiny.R
\name{age_trend_plot}
\alias{age_trend_plot}
\title{Generate Age Trend Plot}
\usage{
age_trend_plot(
  age_list,
  f,
  s = "none",
  q = "median",
  cus_list = NULL,
  use_plotly = TRUE
)
}
\arguments{
\item{age_list}{A list containing all ROIs' true volumes, age trend estimates, and the fitted GAMLSS model.}

\item{f}{A string specifying the feature of interest within the \code{age_list}.}

\item{s}{A string indicating the demographic group for visualization: \code{"F"} for female, \code{"M"} for male, \code{"F vs M"} for gender comparison, or \code{"none"} for base plot (true data) visualization.}

\item{q}{A string specifying the quantile type (e.g., \code{"quantile_75"}, \code{"median"}, or \code{"customization"}).}

\item{cus_list}{A list object containing customized quantile predictions generated by the \code{cus_result_gen} function.}

\item{use_plotly}{A boolean indicating whether to create an interactive plot using \code{plotly} (default: \code{TRUE}).}
}
\value{
A plot object:
\itemize{
\item If \code{use_plotly = TRUE}, returns a \code{plotly} interactive plot.
\item If \code{use_plotly = FALSE}, returns a \code{ggplot2} static plot.
}
}
\description{
This function creates an age trend plot for a specified feature and demographic group based on GAMLSS model predictions.
The function supports both static plots using \code{ggplot2} and interactive plots using \code{plotly}.
}
\details{
The function overlays true data points with predicted quantile trends for the specified feature and demographic group.
It supports customization for quantile visualization and uses precomputed results from the \code{cus_result_gen} function
for enhanced flexibility.
}
\examples{
sub_df <- age_df[,c("Volume_1", "age", "sex", "ICV_baseline")] |> na.omit()
colnames(sub_df) <- c("Volume_1", "age", "sex", "icv")
age_list <- list("Volume_1" = age_list_gen(sub_df = sub_df))
customized_results <- cus_result_gen(age_list, customized_q = 0.75, f = "Volume_1")

if(interactive()){
 age_trend_plot(
   age_list = age_list,
   f = "Volume_1",
   s = "F",
   q = "customization",
   cus_list = customized_results,
   use_plotly = TRUE
 )
}
}
