% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Cox_Refresh_R_TERM}
\alias{Cox_Refresh_R_TERM}
\title{Utility function to refresh risk and subterm matrices for Cox Omnibus function
\code{Cox_Refresh_R_TERM} Called to update matrices}
\usage{
Cox_Refresh_R_TERM(
  totalnum,
  reqrdnum,
  term_tot,
  dint,
  dslp,
  dose_abs_max,
  abs_max,
  df0,
  T0,
  Td0,
  Tdd0,
  Te,
  R,
  Rd,
  Rdd,
  Dose,
  nonDose,
  TTerm,
  nonDose_LIN,
  nonDose_PLIN,
  nonDose_LOGLIN,
  RdR,
  RddR,
  basic_bool,
  single_bool
)
}
\arguments{
\item{totalnum}{total number of parameters}

\item{reqrdnum}{total number of free parameters}

\item{term_tot}{total number of terms}

\item{dint}{value used for threshold derivative finite step}

\item{dslp}{value used for slope derivative finite step}

\item{dose_abs_max}{Maximum allowed threshold parameter change}

\item{abs_max}{Maximum allowed parameter change}

\item{df0}{matrix of covariate values}

\item{T0}{Term value for each subterm}

\item{Td0}{Term by subterm derivative matrix}

\item{Tdd0}{Term by subterm second derivative matrix}

\item{Te}{temporary term storage matrix}

\item{R}{risk vector}

\item{Rd}{Risk first derivative matrix}

\item{Rdd}{Risk second derivative matrix}

\item{Dose}{term matrix}

\item{nonDose}{term matrix}

\item{TTerm}{Total term matrix}

\item{nonDose_LIN}{Linear term matrix}

\item{nonDose_PLIN}{Product linear term matrix}

\item{nonDose_LOGLIN}{Loglinear term matrix}

\item{RdR}{Risk to first derivative ratio matrix}

\item{RddR}{Risk to second derivative ratio matrix}

\item{basic_bool}{boolean for multiplicative log-linear model}

\item{single_bool}{boolean for single calculation without derivatives}
}
\value{
Updates matrices in place
}
\description{
Utility function to refresh risk and subterm matrices for Cox Omnibus function
\code{Cox_Refresh_R_TERM} Called to update matrices
}
