% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{gdp_departments_tbl_df}
\alias{gdp_departments_tbl_df}
\title{Departmental GDP Projection (Spanish speaking)}
\format{
A tibble with 16,302 observations and 7 variables:
\describe{
  \item{Año}{Year of the record (numeric)}
  \item{Actividad}{Economic activity (character)}
  \item{Sector}{Sector of the economy (character)}
  \item{Tipo de precios}{Price type (character)}
  \item{Código Departamento (DIVIPOLA)}{DIVIPOLA code of the department (numeric)}
  \item{Departamento}{Name of the department (character)}
  \item{Valor (miles de millones de pesos)}{GDP value in thousands of millions of pesos (numeric)}
}
}
\source{
Data obtained from GOV.CO Datos Abiertos: \url{https://www.datos.gov.co/Econom-a-y-Finanzas/PIB-Departamental-con-proyecci-n/kgyi-qc7j/about_data}
}
\usage{
data(gdp_departments_tbl_df)
}
\description{
This dataset, gdp_departments_tbl_df, is a tibble containing the projected
Gross Domestic Product (GDP) at constant prices for the departments of Colombia,
expressed in 2015 prices. It includes data such as year, economic activity,
sector, price type, DIVIPOLA department code, department name, and GDP value
in thousands of millions of pesos. The dataset was obtained from GOV.CO Datos
Abiertos, last update on November 1, 2024.
}
\details{
The dataset name has been kept as 'gdp_departments_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
ColombiAPI package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble object. The original content has not
been modified in any way.
}
