% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_readFactory.R
\name{correctTypes_methods}
\alias{correctTypes}
\alias{correctTypes_methods}
\title{Convert columns of a data frame to certain types}
\usage{
correctTypes(dat, col_names = NULL, types)
}
\arguments{
\item{dat}{data.frame The data frame whose types you want to change.}

\item{col_names}{character. Names of columns, the types of which you want to change.}

\item{types}{character. Names of new types. Should be the same length as \code{col_names}}
}
\value{
data.frame. With specified classes.
}
\description{
Convert columns of a data frame to certain types
}
\examples{
\dontrun{
dat = randNormDat(3, 3)
dat[, 2] = as.character(dat$V2)
dat1 = correctTypes(dat, types = rep("numeric", 3))
all(colClasses(dat1) == rep("numeric", 3))
dat2 = correctTypes(dat, 2, "numeric")
all(colClasses(dat2) == rep("numeric", 3))
}
}
\author{
Kaiyin Zhong, Fan Liu
}

