% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intersectCohorts.R
\name{intersectCohorts}
\alias{intersectCohorts}
\title{Generate a combination cohort set between the intersection of different
cohorts.}
\usage{
intersectCohorts(
  cohort,
  cohortId = NULL,
  gap = 0,
  mutuallyExclusive = FALSE,
  returnOnlyComb = FALSE,
  name = tableName(cohort)
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{cohortId}{IDs of the cohorts to include. If NULL all cohorts will be
considered. Cohorts not included will be removed from the cohort set.}

\item{gap}{Number of days between two subsequent cohort entries to be merged
in a single cohort record.}

\item{mutuallyExclusive}{Whether the generated cohorts are mutually
exclusive or not.}

\item{returnOnlyComb}{Whether to only get the combination cohort back}

\item{name}{Name of the new cohort with the demographic requirements.}
}
\value{
A cohort table.
}
\description{
\code{intersectCohorts()} combines different cohort entries, with those records
that overlap combined and kept. Cohort entries are when an individual was in
\emph{both} of the cohorts.
}
\examples{
\donttest{
library(CohortConstructor)

cdm <- mockCohortConstructor(nPerson = 100)

cdm$cohort3 <- intersectCohorts(
  cohort = cdm$cohort2,
  name = "cohort3",
)

settings(cdm$cohort3)

}
}
