% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseOrphanCodes.R
\name{summariseOrphanCodes}
\alias{summariseOrphanCodes}
\title{Find orphan codes related to a codelist using achilles counts and, if
available, PHOEBE concept recommendations}
\usage{
summariseOrphanCodes(
  x,
  cdm,
  domain = c("condition", "device", "drug", "measurement", "observation", "procedure",
    "visit")
)
}
\arguments{
\item{x}{A codelist for which to find related codes used in the database}

\item{cdm}{cdm_reference via CDMConnector}

\item{domain}{The domains to restrict results too. Only concepts from these
domains will be returned.}
}
\value{
A summarised result containg the frequency of codes related
to (but not in) the codelist
}
\description{
Find orphan codes related to a codelist using achilles counts and, if
available, PHOEBE concept recommendations
}
\examples{
\donttest{
cdm <- mockVocabRef("database")
codes <- getCandidateCodes(cdm = cdm,
keywords = "Musculoskeletal disorder",
domains = "Condition",
includeDescendants = FALSE)

orphan_codes <- summariseOrphanCodes(x = list("msk" = codes$concept_id),
cdm = cdm)

orphan_codes
CDMConnector::cdmDisconnect(cdm)
}
}
