% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/achillesCodeUse.R
\name{achillesCodeUse}
\alias{achillesCodeUse}
\title{Summarise code use from achilles counts}
\usage{
achillesCodeUse(x, cdm, countBy = c("record", "person"), minCellCount = 5)
}
\arguments{
\item{x}{Codelist}

\item{cdm}{cdm_reference via CDMConnector::cdm_from_con()}

\item{countBy}{Either "record" for record-level counts or "person" for
person-level counts}

\item{minCellCount}{The minimum number of counts to reported, below which
results will be suppressed.}
}
\value{
A tibble with results
}
\description{
Summarise code use from achilles counts
}
\examples{
\dontrun{
cdm <- mockVocabRef("database")
oa <- getCandidateCodes(cdm = cdm, keywords = "osteoarthritis")
result_achilles <- achillesCodeUse(list(oa = oa$concept_id), cdm = cdm)
result_achilles
CDMConnector::cdmDisconnect(cdm)
}
}
