% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseCodeUse.R
\name{summariseCodeUse}
\alias{summariseCodeUse}
\title{Summarise code use in patient-level data}
\usage{
summariseCodeUse(
  x,
  cdm,
  countBy = c("record", "person"),
  byConcept = TRUE,
  byYear = FALSE,
  bySex = FALSE,
  ageGroup = NULL,
  minCellCount = 5
)
}
\arguments{
\item{x}{Vector of concept IDs}

\item{cdm}{cdm_reference via CDMConnector::cdm_from_con()}

\item{countBy}{Either "record" for record-level counts or "person" for
person-level counts}

\item{byConcept}{TRUE or FALSE. If TRUE code use will be summarised by}

\item{byYear}{TRUE or FALSE. If TRUE code use will be summarised by year.}

\item{bySex}{TRUE or FALSE. If TRUE code use will be summarised by sex.}

\item{ageGroup}{If not NULL, a list of ageGroup vectors of length two.}

\item{minCellCount}{The minimum number of counts to reported, below which
results will be suppressed. If 0, all results will be reported.}
}
\value{
A tibble with results overall and, if specified, by strata
}
\description{
Summarise code use in patient-level data
}
