% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctmaEqual.R
\name{ctmaEqual}
\alias{ctmaEqual}
\title{ctmaEqual}
\usage{
ctmaEqual(
  ctmaInvariantFit = NULL,
  activeDirectory = NULL,
  activateRPB = FALSE,
  digits = 4,
  coresToUse = 2
)
}
\arguments{
\item{ctmaInvariantFit}{object to which a CoTiMA fit has been assigned to (i.e., what has been returned by \code{\link{ctmaFit}}).
In most cases probably a model in which (only) two effects were specified with invariantDrift.}

\item{activeDirectory}{defines another active directory than the one used in ctmaInvariantFit}

\item{activateRPB}{set to TRUE to receive push messages with CoTiMA notifications on your phone}

\item{digits}{Number of digits used for rounding (in outputs)}

\item{coresToUse}{If neg., the value is subtracted from available cores, else value = cores to use}
}
\value{
returns a model where two or more parameters were set equal across primary studies and a log-likelihood difference test
informing about the probability that the equality assumption is correct.
}
\description{
test if the two or more invariant drift parameters in the CoTiMAFit object supplied are equal. The supplied CoTiMA fit-object
(ctmaInvariantFit) has to be a model fitted with \code{\link{ctmaFit}} where at least two parameters were set invariant across primary studies (e.g., 2 cross
effects). All parameters that are set invariant in the supplied model are then constrained to be equal by ctmaEqual (no user action
required), the model is fitted, and a log-liklihood ratio test is performed informing about the probability that equality applies.
}
\examples{
# Fit a CoTiMA with a set of parameters set equal that were set
# invariant in a previous model (of which the fit object is
# supplied in argument ctmaInvariantFit)
\dontrun{
CoTiMAFullInv23Fit_6$activeDirectory <- "/Users/tmp/" # adapt!
CoTiMAFullInvEq23Fit_6 <- ctmaEqual(ctmaInvariantFit=CoTiMAFullInv23Fit_6)
}

}
