% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{checksimulation}
\alias{checksimulation}
\title{Check generated timeseries}
\usage{
checksimulation(TS, distbounds = c(-Inf, Inf), plot = FALSE)
}
\arguments{
\item{TS}{generated timeseries}

\item{distbounds}{distribution bounds (default set to c(-Inf, Inf))}

\item{plot}{logical - plot the result? (if TRUE, saved as an attribute 'plot')}
}
\description{
Compares generated time series sample statistics with the theoretically expected values.
}
\examples{

library(CoSMoS)

## check your generated timeseries
x <- generateTS(margdist = 'burrXII',
                margarg = list(scale = 1,
                               shape1 = .75,
                               shape2 = .25),
                acsvalue = acs(id = 'weibull',
                               t = 0:30,
                               scale = 10,
                               shape = .75),
                n = 1000, p = 30, p0 = .5, TSn = 5)

checksimulation(x)

}
