% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/burrIII.R
\name{BurrIII}
\alias{BurrIII}
\alias{dburrIII}
\alias{pburrIII}
\alias{qburrIII}
\alias{rburrIII}
\alias{mburrIII}
\title{Burr Type III distribution}
\usage{
dburrIII(x, scale, shape1, shape2, log = FALSE)

pburrIII(q, scale, shape1, shape2, lower.tail = TRUE, log.p = FALSE)

qburrIII(p, scale, shape1, shape2, lower.tail = TRUE, log.p = FALSE)

rburrIII(n, scale, shape1, shape2)

mburrIII(r, scale, shape1, shape2)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{scale, shape1, shape2}{scale and shape parameters; the shape arguments cannot be a vectors (must have length one).}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to be the number required.}

\item{r}{raw moment order}
}
\description{
Provides density, distribution function, quantile function, random value generation,
and raw moments of order \emph{r} for the Burr Type III distribution.
}
\examples{

## plot the density

ggplot(data.frame(x = c(1, 15)),
       aes(x)) +
  stat_function(fun = dburrIII,
                args = list(scale = 5,
                            shape1 = .25,
                            shape2 = .75),
                colour = 'royalblue4') +
  labs(x = '',
       y = 'Density') +
  theme_classic()
}
\concept{Continuous}
\concept{Univariate}
\keyword{distribution}
