#' Plot generated Timeseries
#'
#' Visualizes Timeseries generated by the package CoSMoS
#'
#' @param x fitactf result object
#' @param ... other arguments
#'
#' @export
#' @method plot cosmosts
#' @import ggplot2 reshape2
#'
#' @examples
#'
#' library(CoSMoS)
#'
#' ## generate TS
#' ts <- generateTS(margdist = 'ggamma',
#'                  margarg = list(scale = 1,
#'                                 shape1 = .8,
#'                                 shape2 = .8),
#'                  acsvalue = acs(id = 'paretoII',
#'                                 t = 0:30,
#'                                scale = 1,
#'                                 shape = .75),
#'                  n = 1000,
#'                  p = 30,
#'                  TSn = 2)
#'
#' ## plot the TS
#' plot(ts)

plot.cosmosts <- function(x, ...) {

  dta <- data.frame(n = seq_along(x[[1]]), do.call(cbind, x))
  names(dta)[2:(length(x) + 1)] <- paste('timeseries', 1:length(x), sep = '_')

  m.dta <- melt(dta, id.vars = 'n')

  p <- ggplot(m.dta, aes(x = m.dta$n, y = m.dta$value)) +
    geom_col() +
    labs(x = '',
         y = 'value') +
    facet_wrap(~variable, ncol = 1) +
    theme_classic()

  return(p)
}
