% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstParmFunc_FBM.R
\name{EstParmFunc_FBM}
\alias{EstParmFunc_FBM}
\title{Writting the loglikelihood of the dirichlet}
\usage{
EstParmFunc_FBM(param, especie, E, EspecieMaxima, Tt, especiemodi)
}
\arguments{
\item{param}{Vector with the parameters in the following order: a11,a12,a13, a21, a22,a23, ...a(D-1)1,a(D-1)2,a(D-1)3,tau. Where D is the number of bacterial species present in the matrix \code{especie}.}

\item{especie}{Matrix that contains at row i the bacterial taxa of bacteria i at all time points.}

\item{E}{Number of bacteria available}

\item{EspecieMaxima}{Row in which the bacterial with maximum mean abundance is in \code{especie}.This bacteria is used as reference in the alr transformation that the model does and it is placed at the denominator of the balance)}

\item{Tt}{Number of bacteria available}

\item{especiemodi}{Matrix that contains at row i the bacterial taxa of bacteria i at time points t=2,...,\code{Tt}. The bacteria are placed in the same order than in \code{especie}.}
}
\value{
Returns a number with the value of the dirichlet loglikelihood.
}
\description{
This function calculates the loglikelihood of the dirichlet for the FBM model.
}
\details{
The regression of this model is defined by


\deqn{\mu_{it}=a_{i1}+a_{i2}\cdot\text{alr}(x_{i,(t-1)})+a_{i3}\cdot\text{Balance}(x_{i,(t-1)})\text{ for }i=1,\dots, D-1\text{ where } D \text{ is the number of bacteria}}
}
\examples{


especie1=cbind(c(0.5,0.3,0.2), c(0.1,0.3,0.6))
especiemodi=especie1[,-1]
tau1=0.4
parms1= cbind(c(0.1,0.2),c(-0.2,0.1),c(0.3,0.2))
parms11=c(as.vector( t(parms1)),tau1)

EstParmFunc_FBM(parms11,especie1,3 ,3  , 2,especiemodi)

}
\references{
Creus-Martí, I., Moya, A., Santonja, F. J. (2021). A Dirichlet autoregressive model for the analysis of microbiota time-series data. Complexity, 2021, 1-16.
}
