#' @export print.summary.hclustgeo.uniq
#' @name print.summary.hclustgeo.uniq
#' @method print summary.hclustgeo.uniq
#' @S3method print summary.hclustgeo.uniq
#' @title Print a 'summary.hclustgeo.uniq' object
#' @description This is a method for the function print for objects of the class \code{summary.hclustgeo.uniq}.
#' @param x an object of class  \code{summary.hclustgeo.uniq} generated by the function \code{summary.hclustgeo.uniq}
#' @param \dots  further arguments to be passed to or from other methods. They are ignored in this function.
#' @keywords internal

print.summary.hclustgeo.uniq <- function(x, ...){
  if (!inherits(x, "summary.hclustgeo.uniq")) 
    stop("use only with \"summary.hclustgeo.uniq\" objects")
  
  cat("Method = summary.hclustgeo.uniq")
  cat("\n")
  cat("\nCall:\n", deparse(x$call), "\n\n", sep = "")
  
  toprint <- matrix("",7,2)
  colnames(toprint) <-c("name","description")
  toprint[1,] <- c("$alpha", "parameter 'alpha' used in the hclustgeo method")
  toprint[2,] <- c("$K.range", "parameter 'K.range' used in the method") 
  toprint[3,] <- c("$cut", "dataframe whose colums correspond to the different typologies in 'K.range' clusters")
  toprint[4,] <- c("$heterog", "list of heterogeneity criterions for each partitions")
  toprint[5,] <- c("$desc", "List of descriptions of clusters for each partition generated.")
  toprint[6,] <- c("","Partitions are described by variables of 'data.desc'")  
  toprint[7,] <- c("$data.desc", "The data base used to describe cluster of partitions")    
  
  print(toprint)
    
  
}