% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statis.R
\name{statis}
\alias{statis}
\title{Performs the STATIS method on different blocks of quantitative variables}
\usage{
statis(Data,Blocks,NameBlocks=NULL,Graph_obj=TRUE, Graph_weights=TRUE, scale=FALSE)
}
\arguments{
\item{Data}{data frame or matrix. Correspond to all the blocks of variables merged horizontally}

\item{Blocks}{numerical vector. The number of variables of each block. The sum must be equal to the number of columns of Data}

\item{NameBlocks}{string vector. Name of each block. Length must be equal to the length of Blocks vector. If NULL, the names are B1,...Bm. Default: NULL}

\item{Graph_obj}{logical. Show the graphical representation od the objects? Default: TRUE}

\item{Graph_weights}{logical. Should the barplot of the weights be plotted? Default: TRUE}

\item{scale}{logical. Should the data variables be scaled? Default: FALSE}
}
\value{
a list with:
        \itemize{
         \item RV: the RV matrix: a matrix with the RV coefficient between blocks of variables
         \item compromise: a matrix which is the compromise of the blocks (akin to a weighted average)
         \item weights: the weights associated with the blocks to build the compromise
         \item lambda: the first eigenvalue of the RV matrix
         \item overall error : the error for the STATIS criterion
         \item error_by_conf: the error by configuration (STATIS criterion)
         \item rv_with_compromise: the RV coefficient of each block with the compromise
         \item homogeneity: homogeneity of the blocks (in percentage)
         \item coord: the coordinates of each object
         \item eigenvalues: the eigenvalues of the svd decomposition
         \item inertia: the percentage of total variance explained by each axis
         \item error_by_obj: the error by object (STATIS criterion)
         \item scalefactors: the scaling factors of each block
         \item proj_config: the projection of each object of each configuration on the axes: presentation by configuration
         \item proj_objects: the projection of each object of each configuration on the axes: presentation by object
         }
}
\description{
STATIS method on quantitative blocks. SUpplementary outputs are also computed
}
\examples{

 data(smoo)
 NameBlocks=paste0("S",1:24)
 st=statis(Data=smoo, Blocks=rep(2,24),NameBlocks = NameBlocks)
 summary(st)
 #with variables scaling
 st2=statis(Data=smoo, Blocks=rep(2,24),NameBlocks = NameBlocks, Graph_weights=FALSE, scale=TRUE)

}
\references{
\itemize{
\item Lavit, C., Escoufier, Y., Sabatier, R., Traissac, P. (1994). The act (statis method). Computational 462 Statistics & Data Analysis, 18 (1), 97-119.\\
\item Llobell, F., Cariou, V., Vigneau, E., Labenne, A., & Qannari, E. M. (2018). Analysis and clustering of multiblock datasets by means of the STATIS and CLUSTATIS methods.Application to sensometrics. Food Quality and Preference, in Press.
}
}
\seealso{
\code{\link{plot.statis}}, \code{\link{clustatis}}
}
\keyword{quantitative}
