% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability-based-parameter-assessment.R
\name{plot_feature_stability_boxplot}
\alias{plot_feature_stability_boxplot}
\title{Feature Stability Boxplot}
\usage{
plot_feature_stability_boxplot(feature_object_list, text_size = 4)
}
\arguments{
\item{feature_object_list}{An object or a concatenation of objects returned by the
`get_feature_stability` method}

\item{text_size}{The size of the labels above boxplots.}
}
\value{
A ggplot2 object.
}
\description{
Display EC consistency for each feature set and for each step.
Above each boxplot there is a number representing
the step (or the size of the subset)
}
\examples{
set.seed(2021)
# create an artificial expression matrix
expr_matrix = matrix(c(runif(100*10), runif(100*10, min = 3, max = 4)), nrow = 200, byrow = TRUE)
rownames(expr_matrix) = as.character(1:200)
colnames(expr_matrix) = paste("feature", 1:10)

feature_stability_result = get_feature_stability(data_matrix = t(expr_matrix),
   feature_set = colnames(expr_matrix),
   feature_type = "feature_name",
   steps = 5,
   npcs = 2,
   n_repetitions = 10,
   algorithm = 1,
   # the following parameters are used by the umap function and are not mandatory
   n_neighbors = 3,
   approx_pow = TRUE,
   n_epochs = 0,
   init = "random",
   min_dist = 0.3)
plot_feature_stability_boxplot(feature_stability_result)
}
