% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indecis_indices.R
\name{moi}
\alias{moi}
\title{Marsz Oceanity Index}
\usage{
moi(data, value, data_names = NULL, na.rm = FALSE, ...)
}
\arguments{
\item{data}{medium temperature}

\item{value}{lat}

\item{data_names}{names of each period of time}

\item{na.rm}{logical. Should missing values (including NaN) be removed?}

\item{...}{...}
}
\value{
n0to10
}
\description{
MOI = ( 0.731 * geographic latitude grados + 1.767 ) / the annual range of monthly mean air temperatures grados
}
\section{Formula}{
 \deqn{MOI=\frac {0.731 \phi +1.767}{Thm-Tcm}} \deqn{\phi} = geographical latitude; Thm = Average temperature of the hottest month (Celsius); Tcm = Average temperature of the coldest month (Celsius)
}

\examples{
data(data_all)
moi(data = data_all$tg, value = data_all$lat)
}
\references{
Marsz A, Rakusa-Suszczewskis S. 1987. Charakterystyka ekologiczna rejonu Zatoki Admiralicji (King George Island, SouthShetland Islands). 1. Klimat i obszary wolne od lodu.Kosmos36:103–127.
}
