% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotWaterBalance.R
\name{plotWaterBalance}
\alias{plotWaterBalance}
\title{Plot components of the urban water balance}
\usage{
plotWaterBalance(data, yl = "Your y-axis label", annual = FALSE)
}
\arguments{
\item{data}{xts or zoo object}

\item{yl}{y-axis label}

\item{annual}{flag indicating whether to plot annual totals}
}
\value{
plot
}
\description{
This function plots input to or output from `CityWaterBalance`.
}
\examples{
global_flows <- cwb_data[,c(1,2,4,5)]
plotWaterBalance(global_flows)
p <- list("interc" = 0,"et_mult" = 1,"flow_mult" = 1,"open_wat" = 0.02, 
   "run_mult" = 3.378, "run_css" = 0.35, "bf_mult" = 1, "nonrev"=0.08,
   "ind_evap"=0.012,"wast_gen" = 0.85,"pot_atm" = 0.13,"npot_infilt" = 0.5,
   "slud_evap" = 0,"leak_css" = 0.05,"dgw" = 0.5, "dgw_rep" = 0.5)
m <- CityWaterBalance(cwb_data,p)
f <- m$all_flows
css_flows <- f[,c(3,12,27,30,34)]
plotWaterBalance(css_flows)
}
