% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{logLik_resp}
\alias{logLik_resp}
\title{Log-Likelihood for Continuous Reports}
\usage{
logLik_resp(x, pVec)
}
\arguments{
\item{x}{a matrix storing a first column as RT and a second column of
continuous responses/reports/outcomes. Each row is a trial.}

\item{pVec}{a parameter vector with the order [a, vx, vy, t0, s],
or [thresh, mu1, mu2, ndt, sigmasq], using alternative names.}
}
\value{
a vector
}
\description{
Calculate log-likelihood of the continuous reports, using
part part in equation (23) on p 433.
}
\examples{
x <- cbind(
RT=c(1.2595272, 0.8693937, 0.8009044, 1.0018933, 2.3640007, 1.0521304),
R =c(1.9217430, 1.7844653, 0.2662521, 2.1569724, 1.7277440, 0.8607271)
)
pVec <- c(a=2.45, vx=1.5, vy=1.25, t0=.1, s=1)
den  <- logLik_resp(x, pVec=pVec); den
}
\references{
Smith, P. L. (2016). Diffusion Theory of Decision Making in
Continuous Report, Psychological Review, 123 (4), 425--451.
}
