% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_Librino.R
\name{validate_Librino}
\alias{validate_Librino}
\title{Simple validation test of the output of Librino_N()}
\usage{
validate_Librino(librino, radii)
}
\arguments{
\item{librino}{A named numeric vector with the  from resulting from [Librino_N()]}

\item{radii}{Numeric vectors of length N with the radius of each circle.}
}
\value{
TRUE if all the partitions of the circles add to their total area,
else a numeric vector with the number of the circles that failed this test.
}
\description{
Checks if the sum of the areas of intersection of each
circle adds to the total area of the circle, as it should.
}
\examples{
# Example of intersection areas including a Reuleaux triangle
x <- c(0, 1, 0.5)
y <-c(0, 0, sqrt(1-0.5**2))
radii <- c(1, 1, 1)
intersections <- Librino_N(centers_x = x, centers_y = y, radii = radii)
validate_Librino(librino = unlist(intersections, use.names = TRUE), radii = radii)
}
\author{
Hugo Salinas \email{hugosal@comunidad.unam.mx}.
}
