% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choR.R
\name{ChoR.SMT}
\alias{ChoR.SMT}
\title{Call to the SMT chordalysis algorithm.}
\usage{
ChoR.SMT(x, pValueThreshold = 0.05, card = NULL)
}
\arguments{
\item{x}{A dataframe with categorical data; column names are the name of the attributes.}

\item{pValueThreshold}{A double value, minimum p-value for statistical consistency (commonly 0.05)}

\item{card}{A vector containing the cardinality of the attributes (position wise).}
}
\value{
A Chordalysis object. Use \code{ChoR.as.*} functions to access the result.
}
\description{
Searches a statistically significant decomposable model to explain a dataset using Prioritized Chordalysis.
}
\details{
Call the SMT chordalysis function on the dataframe x. The optionnal card argument can provide a vector
of cardinalities for each attribute (i.e. column) of the dataframe. If absent, the cardinalities are computed
from the dataframe, but may not be accurate if some possible values never show up. See papers
"A multiple test correction for streams and cascades of statistical hypothesis tests, KDD 2016",
"Scaling log-linear analysis to high-dimensional data, ICDM 2013", and
"Scaling log-linear analysis to datasets with thousands of variables, SDM 2015" for more details.
}
\examples{
\dontrun{ res = ChoR.SMT(data, 0.05, c(3, 5, 4, 4, 3, 2, 3, 3)) }
\dontrun{ res = ChoR.SMT(data, card = c(3, 5, 4, 4, 3, 2, 3, 3)) }
}
