% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{pinochet_regime_df}
\alias{pinochet_regime_df}
\title{Human Rights Abuses in the Pinochet Regime (1973–1990)}
\format{
A data frame with 2,398 observations and 59 variables:
\describe{
  \item{individual_id}{Victim ID}
  \item{group_id}{Group ID for collective incidents}
  \item{start_date_daily}{Start date (day precision)}
  \item{end_date_daily}{End date (day precision)}
  \item{start_date_monthly}{Start date (month precision)}
  \item{end_date_monthly}{End date (month precision)}
  \item{last_name}{Victim's last name}
  \item{first_name}{Victim's first name}
  \item{minor}{Indicator if victim was a minor}
  \item{age}{Age of the victim}
  \item{male}{Indicator if victim was male}
  \item{occupation}{Victim's occupation}
  \item{occupation_detail}{Detailed occupation description}
  \item{victim_affiliation}{Affiliation of the victim}
  \item{victim_affiliation_detail}{Detailed affiliation}
  \item{violence}{Type of violence experienced}
  \item{method}{Method of violence}
  \item{interrogation}{Interrogation indicator}
  \item{torture}{Torture indicator}
  \item{mistreatment}{Mistreatment indicator}
  \item{targeted}{Targeting category}
  \item{press}{Indicator for press involvement}
  \item{war_tribunal}{War tribunal indicator}
  \item{number_previous_arrests}{Number of previous arrests}
  \item{perpetrator_affiliation}{Affiliation of perpetrator}
  \item{perpetrator_affiliation_detail}{Detailed affiliation of perpetrator}
  \item{nationality}{Victim's nationality}
  \item{place_1}{First incident location}
  \item{location_1}{First location detail}
  \item{latitude_1}{Latitude of first location}
  \item{longitude_1}{Longitude of first location}
  \item{exact_coordinates_1}{Indicator of coordinate precision (1 = exact)}
  \item{place_2}{Second incident location}
  \item{location_2}{Second location detail}
  \item{latitude_2}{Latitude of second location}
  \item{longitude_2}{Longitude of second location}
  \item{exact_coordinates_2}{Indicator of coordinate precision (2nd)}
  \item{place_3}{Third incident location}
  \item{location_3}{Third location detail}
  \item{latitude_3}{Latitude of third location}
  \item{longitude_3}{Longitude of third location}
  \item{exact_coordinates_3}{Indicator of coordinate precision (3rd)}
  \item{place_4}{Fourth incident location}
  \item{location_4}{Fourth location detail}
  \item{latitude_4}{Latitude of fourth location}
  \item{longitude_4}{Longitude of fourth location}
  \item{exact_coordinates_4}{Indicator of coordinate precision (4th)}
  \item{place_5}{Fifth incident location}
  \item{location_5}{Fifth location detail}
  \item{latitude_5}{Latitude of fifth location}
  \item{longitude_5}{Longitude of fifth location}
  \item{exact_coordinates_5}{Indicator of coordinate precision (5th)}
  \item{place_6}{Sixth incident location}
  \item{location_6}{Sixth location detail}
  \item{latitude_6}{Latitude of sixth location}
  \item{longitude_6}{Longitude of sixth location}
  \item{exact_coordinates_6}{Indicator of coordinate precision (6th)}
  \item{page}{Source page in the original report}
  \item{additional_comments}{Additional remarks or context}
}
}
\source{
Data taken from the pinochet package version 0.1.0.
}
\usage{
data(pinochet_regime_df)
}
\description{
This dataset, pinochet_regime_df, is a data frame containing detailed information about human rights violations
that occurred in Chile during the military dictatorship of Augusto Pinochet, spanning from 1973 to 1990.
The data includes victim-level records such as names, age, gender, affiliation, nature of the violence,
methods used, and geographic information when available. It is based on the National Truth and Reconciliation
Commission Report (1991, ISBN:9780268016463). The dataset also includes georeferenced locations across
multiple levels for incidents where such data could be retrieved.
}
\details{
The dataset name has been kept as pinochet_regime_df to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
ChileDataAPI package and assists users in identifying its specific characteristics.
The suffix df indicates that the dataset is a data frame. The original content has not been modified.
}
