% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pfacLoadings.R
\name{pfacLoadings}
\alias{pfacLoadings}
\title{Plot Loadings from a PARAFAC Analysis of a Spectra2D Object}
\usage{
pfacLoadings(spectra, pfac, load = 1, ref = NULL, load_lvls = NULL,
  ref_lvls = NULL, load_cols = NULL, ref_cols = NULL, plot = TRUE,
  ...)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link{Spectra2D}}.}

\item{pfac}{An object of class \code{parafac} obtained by running \code{\link{pfacSpectra2D}}.}

\item{load}{An integer specifying the loading to plot.}

\item{ref}{An integer giving the spectrum in \code{spectra} to use
as a reference spectrum, which is plotted behind the loadings.
Defaults to \code{NULL} which does not plot a reference spectrum.}

\item{load_lvls}{A vector specifying the contour levels
for the loadings pseudo-spectrum.
If \code{NULL}, values are computed using \code{calcLvls}.}

\item{ref_lvls}{A vector specifying the levels at which to compute contours
for the reference spectrum.
If \code{NULL}, values are computed using \code{calcLvls}.}

\item{load_cols}{A vector specifying the colors for the contours in the laoding spectrum.
If \code{NULL}, defaults to a scheme of values
running from blue (low) to red (high), centered on green (zero).}

\item{ref_cols}{A vector specifying the colors for the contours in the reference
spectrum. If \code{NULL}, set to gray.}

\item{plot}{Logical.  Shall a plot be made?  Plotting large data sets can be slow.
Run the function with \code{plot = FALSE}, then use \code{\link{inspectLvls}}
to figure out desirable levels, then create the plot.}

\item{\dots}{Additional parameters to be passed to plotting functions.  For instance
\code{showGrid = TRUE}.}
}
\value{
The modified \code{Spectra2D} object is returned invisibly.
The loadings matrix will be appended.  Side effect is a plot.
}
\description{
Plots loadings from the PARAFAC analysis of a \code{\link{Spectra2D}} object.
The loadings are computed by multipling matrix \code{A} by matrix \code{B}
in the \code{parafac} object, for a given component.  The matrix that results
has dimensions
F2 x F1 and is a 2D pseudo-spectrum.  A reference spectrum may also be drawn.
}
\section{Scale}{

You can view the color scale for the plot via \code{\link{showScale}}.
}

\section{Levels & Colors}{

The number of levels and colors must match, and they are used 1 for 1.  If you
provide \code{n} colors, and no levels, the automatic calculation of levels may return
a number of levels other than \code{n}, in which case the function will override your colors and
assign new colors for the number of levels it computed (with a message).  To get
exactly what you want, specify both levels and colors in equal numbers.  Function
\code{\link{inspectLvls}} can help you choose appropriate levels.
}

\seealso{
Please see \code{\link{pfacSpectra2D}} for examples.
}
\author{
Bryan A. Hanson, DePauw University.
}
\keyword{hplot}
