% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfN_Logarithmic.R
\name{cfN_Logarithmic}
\alias{cfN_Logarithmic}
\title{Characteristic function of Logarithmic distribution}
\usage{
cfN_Logarithmic(t, p = 0.5, cfX)
}
\arguments{
\item{t}{numerical values (number, vector...)}

\item{p}{success probability, \eqn{0 \le p \le 1}, default value p = 1/2}

\item{cfX}{function}
}
\value{
characteristic function cf(t) of the Logarithmic distribution p success probability
}
\description{
cfN_Logarithmic(t, p) evaluates the characteristic function cf(t) of the
Logarithmic distribution defined on non-negative integers n =0, 1, ...,
with the parameters p (success probability p in [0,1]), i.e.
cfN_Logarithmic(t, p) = log(1 - p * exp(1i*t)) / log(1 - p)

cfN_Logarithmic(t,p,cfX) evaluates the compound characteristic function
cf(t) = cfN_Logarithmic(-1i*log(cfX(t)), p), where cfX is function
handle of the characteristic function cfX(t) of a continuous distribution
and/or random variable X.

Note that such CF is characteristic function of the compound distribution,
i.e. distribution of the random variable Y = X_1 + ... + X_N, where X_i ~ F_X
are i.i.d. random variables with common CF cfX(t), and N ~ F_N is
independent RV with its CF given by cfN(t).
}
\examples{
## EXAMPLE1 (CF of the Logarithmic distribution with the parameter p = 0.5)
p <- 0.5
t <- seq(-10, 10, length.out = 501)
plotGraf(function(t)
  cfN_Logarithmic(t, p), t, title = "CF of the Logarithmic distribution with the parameter p = 0.5")

#' ## EXAMPLE2 (CF of the compound Logarithmic-Exponential distributionn)
p <- 0.5
lambda <- 5
cfX <- function(t)
  cfX_Exponential(t, lambda)
t <- seq(-10, 10, length.out = 501)
plotGraf(function(t)
  cfN_Logarithmic(t, p, cfX), t, title = "CF of the compound Logarithmic-Exponential distribution")

## EXAMPLE3 (PDF/CDF of the compound Logarithmic-Exponential distribution)
p <- 0.5
lambda <- 5
cfX <- function(t)
  cfX_Exponential(t, lambda)
cf <- function(t)
  cfN_Logarithmic(t, p, cfX)
x <- seq(0, 3, length.out = 101)
prob <- c(0.9, 0.95, 0.99)
result <- cf2DistGP(cf, x, prob, isCompound = TRUE)
}
\seealso{
For more details see WIKIPEDIA:
\url{https://en.wikipedia.org/wiki/Logarithmic_distribution}

Other Discrete Probability Distribution: \code{\link{cfN_Binomial}},
  \code{\link{cfN_Delaporte}},
  \code{\link{cfN_GeneralizedPoisson}},
  \code{\link{cfN_Geometric}},
  \code{\link{cfN_NegativeBinomial}},
  \code{\link{cfN_Poisson}},
  \code{\link{cfN_PolyaEggenberger}}
}

