% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_ModelEmax.R
\name{create_ModelEmax}
\alias{create_ModelEmax}
\title{Get the list of objects describing the PML models by set of Emax parameters}
\usage{
create_ModelEmax(
  Baseline = FALSE,
  Fractional = FALSE,
  Inhibitory = FALSE,
  Sigmoid = FALSE,
  ByVector = FALSE,
  ...
)
}
\arguments{
\item{Baseline}{Logical indicating whether the Emax model contains a baseline
response. If it is set to TRUE,  the new parameter, E0, for baseline
response is added to the model. Default is \code{FALSE}.}

\item{Fractional}{Logical indicating whether the Emax model with baseline
response is fractional. Applicable only for the Emax models with baseline
response, otherwise a warning is given and current parameter is ignored.
Default is \code{FALSE}.}

\item{Inhibitory}{Logical indicating whether the model is inhibitory. If it
is set to TRUE, the structural parameters 'EC50' and 'Emax' change to
'IC50' (concentration producing 50\% of maximal inhibition) and 'Imax'.
Default is \code{FALSE}.}

\item{Sigmoid}{Logical indicating whether the model is sigmoidal. If it is
set to TRUE, the Hill coefficient, 'Gam', is added to the model. Default is
\code{FALSE}.}

\item{ByVector}{Logical indicating whether each element in vectorized
argument should be treated as a separate PML structure (i.e. treated as
data.frame vectors), \code{TRUE}, or as parameters to obtain a pool (i.e.
expanded) of PML structures, \code{FALSE}. Default is \code{FALSE} (one value for a
function call).}

\item{...}{Additional named arguments, including Structural parameters
(StParm), Covariates, Dosepoints (for PK models), Thetas and Omegas. See
'Additional arguments' section.}
}
\value{
A list of PML models (\code{PMLModels} class instance) matching the
specified options.
}
\description{
This function provides the PML (Pharmacometric Modelling Language) Emax
parameter sets based on the specified options. They are available as a list
of specific S3 classes.
}
\examples{
# Get Emax model set with default options
PDParametersSets <- create_ModelEmax()

# Create Emax model set with all possible combinations
# will give a warning since When 'Baseline == FALSE',
# there could be no model with 'Fractional == TRUE'
PDParametersSets <-
  create_ModelEmax(Baseline = TRUE,
                   Fractional = c(FALSE, TRUE),
                   Inhibitory = c(FALSE, TRUE),
                   Sigmoid = c(FALSE, TRUE),
                   ByVector = FALSE)

}
