CensMixReg <- function(cc, y, x1, Abetas = NULL, medj= NULL, sigma2 = NULL, nu=NULL, pii = NULL, g = NULL, get.init = TRUE, criteria = TRUE, group = FALSE, family = "T", error = 0.00001, iter.max = 100, obs.prob= FALSE, kmeans.param = NULL)
{
  #Running the algorithm
  out <- CensMixRegEM(cc, y, x1, Abetas, medj, sigma2, nu, pii, g, get.init, criteria, group, family, error, iter.max, obs.prob, kmeans.param)
  #EP  <- sqrt(diag(solve(imm.fmcr(y,x1,cc, out)$IM)))
  #show result
  cat('\n')
  cat('---------------------------------------------------------\n')
  cat('           Censored linear mixture regression model      \n')
  cat('---------------------------------------------------------\n')
  cat('\n')
  cat('Observations =',length(y))
  cat('\n')
  cat('-----------\n')
  cat('Estimates\n')
  cat('-----------\n')
  cat('\n')
  #tttable           <- data.frame(out$ttable,c(EP,0))
  #colnames(tttable) <- c("Estimate","SE")
  print(round(out$ttable,5))
  cat('------------------------\n')
  cat('Model selection criteria\n')
  cat('------------------------\n')
  cat('\n')
  critFin  <- c(out$loglik, out$aic, out$bic, out$edc)
  critFin  <- round(t(as.matrix(critFin)),digits=3)
  dimnames(critFin) <- list(c("Value"),c("Loglik", "AIC", "BIC","EDC"))
  print(critFin)
  cat('-------\n')
  cat('Details\n')
  cat('-------\n')
  cat('\n')
  cat('Iterations =',out$iter)
  cat('\n')
  cat("Processing time =",out$time,units(out$time))
  cat('\n')
  res            <- list(iter = out$count, Abetas = out$Abetas, medj=out$medj, sigma2=out$sigma2, pii=out$pii, nu=out$nu, ttable = out$table,loglik=out$loglik, AIC=out$aic, BIC=out$bic, EDC=out$edc, time = out$time)
  obj.out        <- list(res = res)
  return(obj.out)
}

