\name{p.table}
\alias{p.table}
\title{Table of p-values of pathways}
\description{
Table of p-values of pathways
}
\usage{
p.table(x)
}
\arguments{
  \item{x}{a \link{cepa.all} object}
}
\value{
A data matrix where rows are pathways and columns are centralities.
}
\author{Zuguang Gu}
\seealso{
\code{\link{cepa}}
}
\examples{
\dontrun{
data(PID.db)

# ORA extension
data(gene.list)
# will spend about 20 min
res.ora = cepa.all(dif = gene.list$dif, bk = gene.list$bk, pc = PID.db$NCI)
p.table(res.ora)

# GSA extension
# P53_symbol.gct and P53_cls can be downloaded from
# http://mcube.nju.edu.cn/jwang/lab/soft/cepa/
eset = read.gct("P53_symbol.gct")
label = read.cls("P53.cls", treatment="MUT", control="WT")
# will spend about 45 min
res.gsa = cepa.all(mat = eset, label = label, pc = PID.db$NCI)
p.table(res.gsa)
}
}
