% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_model.R
\name{update_model}
\alias{update_model}
\title{Fit causal model using 'stan'}
\usage{
update_model(
  model,
  data = NULL,
  data_type = NULL,
  keep_type_distribution = TRUE,
  keep_event_probabilities = FALSE,
  keep_fit = FALSE,
  censored_types = NULL,
  ...
)
}
\arguments{
\item{model}{A \code{causal_model}. A model object generated by
\code{\link{make_model}}.}

\item{data}{A \code{data.frame}.  Data of nodes that can take three values:
0, 1, and NA. In long form as generated by \code{\link{make_events}}}

\item{data_type}{Either 'long' (as made by \code{\link{make_data}}) or
'compact' (as made by \code{\link{collapse_data}}). Compact data must
have entries for each member of each strategy family to produce a
valid simplex. When long form data is provided with missingness, missing
data is assumed to be missing at random.}

\item{keep_type_distribution}{Logical. Whether to keep the (transformed) distribution
of the causal types.  Defaults to `TRUE`}

\item{keep_event_probabilities}{Logical. Whether to keep the (transformed) distribution
of event probabilities. Defaults to `FALSE`}

\item{keep_fit}{Logical. Whether to keep the \code{stanfit} object produced
by \link[rstan]{sampling} for further inspection.
See \code{?stanfit} for more details. Defaults to `FALSE`. Note the  \code{stanfit}
object has internal names for parameters (lambda), event probabilities (w), and the
type distribution (types)}

\item{censored_types}{vector of data types that are selected out of
the data, e.g. \code{c("X0Y0")}}

\item{...}{Options passed onto \link[rstan]{sampling} call. For
details see \code{?rstan::sampling}}
}
\value{
An object of class \code{causal_model}. The returned model is a
  list containing the elements comprising a model
  (e.g. 'statement', 'nodal_types' and 'DAG') with the
  \code{posterior_distribution} returned by \link[rstan]{stan}
  attached to it.
}
\description{
Takes a model and data and returns a model object with data
attached and a posterior model
}
\examples{
 model <- make_model('X->Y')
 data_long   <- make_data(model, n = 4)
 data_short  <- collapse_data(data_long, model)
 model <-  update_model(model, data_long)
 model <-  update_model(model, data_short)

   # It is possible to implement updating without data, in which
   # case the posterior is a stan object that reflects the prior

   update_model(model)

 \dontrun{

   # Censored data types illustrations
   # Here we update less than we might because we are aware of filtered data

   data <- data.frame(X=rep(0:1, 10), Y=rep(0:1,10))
   uncensored <-
     make_model("X->Y") |>
     update_model(data) |>
     query_model(te("X", "Y"), using = "posteriors")

   censored <-
     make_model("X->Y") |>
     update_model(
       data,
       censored_types = c("X1Y0")) |>
     query_model(te("X", "Y"), using = "posteriors")


   # Censored data: We learn nothing because the data
   # we see is the only data we could ever see
   make_model("X->Y") |>
     update_model(
       data,
       censored_types = c("X1Y0", "X0Y0", "X0Y1")) |>
     query_model(te("X", "Y"), using = "posteriors")
 }

}
\seealso{
\code{\link{make_model}} allows to create new model,
  \code{\link{summary.causal_model}} provides summary method for
  output objects of class \code{causal_model}
}
