% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_event_prob.R
\name{get_event_probabilities}
\alias{get_event_probabilities}
\title{Draw event probabilities}
\usage{
get_event_probabilities(
  model,
  parameters = NULL,
  A = NULL,
  P = NULL,
  given = NULL
)
}
\arguments{
\item{model}{A \code{causal_model}. A model object generated by
\code{\link{make_model}}.}

\item{parameters}{A vector of real numbers in [0,1]. Values of parameters to
specify (optional). By default, parameters is drawn from
\code{model$parameters_df}.}

\item{A}{A \code{data.frame}. Ambiguity matrix. Not required but may be
provided to avoid repeated computation for simulations.}

\item{P}{A \code{data.frame}. Parameter matrix. Not required but may be
provided to avoid repeated computation for simulations.}

\item{given}{A string specifying known values on nodes, e.g. "X==1 & Y==1"}
}
\value{
An array of event probabilities
}
\description{
`get_event_probabilities` draws event probability vector `w` given a single
realization of parameters
}
\examples{
\donttest{
model <- make_model('X -> Y')
get_event_probabilities(model = model)
get_event_probabilities(model = model, given = "X==1")
get_event_probabilities(model = model, parameters = rep(1, 6))
get_event_probabilities(model = model, parameters = 1:6)
}

}
