% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile_pseudo_pop.R
\name{compile_pseudo_pop}
\alias{compile_pseudo_pop}
\title{Compile Pseudo Population}
\usage{
compile_pseudo_pop(
  data_obj,
  ci_appr,
  gps_model,
  bin_seq,
  nthread,
  optimized_compile,
  ...
)
}
\arguments{
\item{data_obj}{A S3 object including the following:
\itemize{
\item Original data set + GPS values (Y, w, GPS, counter, row_index, c)
\item e_gps_pred
\item e_gps_std_pred
\item w_resid
\item gps_mx (min and max of gps)
\item w_mx (min and max of w).
}}

\item{ci_appr}{Causal inference approach.}

\item{gps_model}{Model type which is used for estimating GPS value, including
parametric and non-parametric.}

\item{bin_seq}{Sequence of w (treatment) to generate pseudo population. If
NULL is passed the default value will be used, which is
\code{seq(min(w)+delta_n/2,max(w), by=delta_n)}.}

\item{nthread}{An integer value that represents the number of threads to be
used by internal packages.}

\item{optimized_compile}{If TRUE, uses counts to keep track of number of
replicated pseudo population.}

\item{...}{Additional parameters.}
}
\value{
\code{compile_pseudo_pop} returns the pseudo population data that is compiled based
on the selected causal inference approach.
}
\description{
Compiles pseudo population based on the original population and estimated GPS
value.
}
\note{
The input data set should be output of estimate_gps function with
internal_use flag activated.
}
\examples{

set.seed(112)
m_d <- generate_syn_data(sample_size = 100)
data_with_gps <- estimate_gps(m_d$Y,
                              m_d$treat,
                              m_d[c("cf1","cf2","cf3","cf4","cf5","cf6")],
                              pred_model = "sl",
                              gps_model = "parametric",
                              internal_use = TRUE,
                              params = list(xgb_max_depth = c(3,4,5),
                                       xgb_nrounds=c(10,20,30,40,50,60)),
                              nthread = 1,
                              sl_lib = c("m_xgboost")
                             )


pd <- compile_pseudo_pop(data_obj = data_with_gps,
                         ci_appr = "matching",
                         gps_model = "parametric",
                         bin_seq = NULL,
                         nthread = 1,
                         optimized_compile=TRUE,
                         matching_fun = "matching_l1",
                         covar_bl_method = 'absolute',
                         covar_bl_trs = 0.1,
                         covar_bl_trs_type= "mean",
                         delta_n = 0.5,
                         scale = 1)

}
