% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootSlope.R, R/bootSlope.default.R,
%   R/bootSlope.formula.R
\name{bootSlope}
\alias{bootSlope}
\alias{bootSlope.default}
\alias{bootSlope.formula}
\title{Bootstrap the slope of a simple linear regression line}
\usage{
bootSlope(x, ...)

\method{bootSlope}{default}(
  x,
  y,
  conf.level = 0.95,
  B = 10000,
  plot.hist = TRUE,
  hist.title = NULL,
  plot.qq = FALSE,
  legend.loc = "topright",
  x.name = deparse(substitute(x)),
  y.name = deparse(substitute(y)),
  ...
)

\method{bootSlope}{formula}(formula, data, subset, ...)
}
\arguments{
\item{x}{a numeric vector.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{y}{a numeric vector.}

\item{conf.level}{confidence level for the bootstrap percentile interval.}

\item{B}{number of times to resample (positive integer greater than 2).}

\item{plot.hist}{a logical value. If \code{TRUE}, plot the bootstrap
distribution of the resampled slope.}

\item{hist.title}{a user supplied title for the histogram.}

\item{plot.qq}{a logical value. If \code{TRUE} a normal quantile-quantile
plot of the bootstraped values is created.}

\item{legend.loc}{location to place the legend. Options include
\code{"topright"}, \code{"topleft"}, \code{"bottomright"},
\code{"bottomleft"}.}

\item{x.name}{Label for variable x}

\item{y.name}{Label for variable y}

\item{formula}{a formula of the form lhs ~ rhs where lhs is a numeric variable 
giving the data values and rhs a factor with two levels giving the corresponding groups.}

\item{data}{an optional data frame containing the variables in the formula formula.
By default the variables are taken from environment(formula).}

\item{subset}{an optional vector specifying a subset of observations to be used.}
}
\value{
The command invisibly returns the slopes of the resampled
observations.
}
\description{
Bootstrap theslope of a simple linear regression line. The bootstrap mean and
standard error are printed as well as a bootstrap percentile confidence
interval.
}
\details{
Observations with missing values are removed.
}
\section{Methods (by class)}{
\itemize{
\item \code{bootSlope(default)}: Bootstrap the slope of a simple linear regression line

\item \code{bootSlope(formula)}: Bootstrap the slope of a simple linear regression line

}}
\examples{


plot(states03$ColGrad, states03$InfMortality)
bootSlope(InfMortality ~ ColGrad, data = states03, B = 1000)
bootSlope(states03$ColGrad, states03$InfMortality, B = 1000)

}
\references{
Tim Hesterberg's website
\url{https://www.timhesterberg.net/bootstrap-and-resampling}
}
\author{
Adam Loy, Laura Chihara
}
\keyword{randomiziation}
\keyword{resampling}
