% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcspline.plot.noprint.R
\name{.rcspline.plot}
\alias{.rcspline.plot}
\title{Internal function}
\usage{
.rcspline.plot(
  x,
  y,
  model = c("logistic", "cox", "ols"),
  xrange,
  event,
  nk = 5,
  knots = NULL,
  show = c("xbeta", "prob"),
  adj = NULL,
  xlab,
  ylab,
  ylim,
  plim = c(0, 1),
  plotcl = TRUE,
  showknots = TRUE,
  add = FALSE,
  plot = TRUE,
  subset,
  lty = 1,
  noprint = FALSE,
  m,
  smooth = FALSE,
  bass = 1,
  main = "auto",
  statloc
)
}
\arguments{
\item{x}{a numeric predictor}

\item{y}{a numeric response. For binary logistic regression, \code{y} should be either 0 or 1.}

\item{model}{\code{"logistic"} or \code{"cox"}. For \code{"cox"}, uses the \code{coxph.fit} function with \code{method="efron"} arguement set.}

\item{xrange}{range for evaluating \code{x}, default is \eqn{f} and \eqn{1 - f} quantiles of \code{x},
where \eqn{f = \frac{10}{\max{(n, 200)}}}{f = 10/max(\code{n}, 200)} and \eqn{n} the number of observations}

\item{event}{event/censoring indicator if \code{model="cox"}. If \code{event} is present, \code{model} is assumed to be \code{"cox"}}

\item{nk}{number of knots}

\item{knots}{knot locations, default based on quantiles of \code{x} (by \code{\link[Hmisc]{rcspline.eval}})}

\item{show}{\code{"xbeta"} or \code{"prob"} - what is plotted on \verb{y}-axis}

\item{adj}{optional matrix of adjustment variables}

\item{xlab}{\verb{x}-axis label, default is the \dQuote{label} attribute of \code{x}}

\item{ylab}{\verb{y}-axis label, default is the \dQuote{label} attribute of \code{y}}

\item{ylim}{\verb{y}-axis limits for logit or log hazard}

\item{plim}{\verb{y}-axis limits for probability scale}

\item{plotcl}{plot confidence limits}

\item{showknots}{show knot locations with arrows}

\item{add}{add this plot to an already existing plot}

\item{plot}{logical to indicate whether a plot has to be made. \code{FALSE} suppresses the plot.}

\item{subset}{subset of observations to process, e.g. \code{sex == "male"}}

\item{lty}{line type for plotting estimated spline function}

\item{noprint}{suppress printing regression coefficients and standard errors}

\item{m}{for \code{model="logistic"}, plot grouped estimates with triangles. Each group contains \code{m} ordered observations on \code{x}.}

\item{smooth}{plot nonparametric estimate if \code{model="logistic"} and \code{adj} is not specified}

\item{bass}{smoothing parameter (see \code{supsmu})}

\item{main}{main title, default is \code{"Estimated Spline Transformation"}}

\item{statloc}{location of summary statistics. Default positioning by clicking left mouse button where upper left corner of statistics should appear.
Alternative is \code{"ll"} to place below the graph on the lower left, or the actual \code{x} and \code{y} coordinates. Use \code{"none"} to suppress statistics.}
}
\value{
list with components (\samp{knots}, \samp{x}, \samp{xbeta}, \samp{lower}, \samp{upper}) which are respectively the knot locations, design matrix,
linear predictor, and lower and upper confidence limits
}
\description{
Adjusted version of the \code{\link[Hmisc]{rcspline.plot}} function where only the output is returned and no plot is made
}
\seealso{
\code{\link[rms]{lrm}}, \code{\link[rms]{cph}}, \code{\link[Hmisc]{rcspline.eval}}, \code{\link[graphics]{plot}}, \code{\link[stats]{supsmu}},
\code{\link[survival:survival-internal]{coxph.fit}}, \code{\link[rms]{lrm.fit}}
}
