% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_CVrisk.R
\name{compute_CVrisk}
\alias{compute_CVrisk}
\title{Compute multiple CV risk scores}
\usage{
compute_CVrisk(
  df,
  scores = c("ascvd_10y_accaha", "ascvd_10y_frs", "ascvd_10y_frs_simple",
    "chd_10y_mesa", "chd_10y_mesa_cac"),
  age,
  gender,
  race,
  sbp = NULL,
  bmi = NULL,
  hdl = NULL,
  totchol = NULL,
  bp_med = NULL,
  smoker = NULL,
  diabetes = NULL,
  lipid_med = NULL,
  fh_heartattack = NULL,
  cac = NULL
)
}
\arguments{
\item{df}{input dataframe}

\item{scores}{scores to compute, default is all scores}

\item{age}{patient age in years (required for all scores)}

\item{gender}{patient gender (male or female)}

\item{race}{character string for patient race (white, aa, other) column}

\item{sbp}{character string of systolic blood pressure (in mm Hg) column}

\item{bmi}{character string of Body mass index (kg/m2) column}

\item{hdl}{character string of HDL column}

\item{totchol}{character string of total cholesterol column}

\item{bp_med}{character string of blood pressure medication column}

\item{smoker}{character string of smoking status column}

\item{diabetes}{character string of diabetes status column}

\item{lipid_med}{character string of lipid medication column}

\item{fh_heartattack}{character string of fh of heart attack status column}

\item{cac}{character string of cac column}
}
\value{
input data frame with risk score results appended as columns
}
\description{
Compute multiple CV risk scores
}
\examples{

library(CVrisk)
compute_CVrisk(sample_data,
  age = "age", race = "race", gender = "gender", bmi = "BMI", sbp = "sbp",
  hdl = "hdl", totchol = "totchol", bp_med = "bp_med", smoker = "smoker",
  diabetes = "diabetes", lipid_med = "lipid_med",
  fh_heartattack = "fh_heartattack", cac = "cac"
)
}
