% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reductions.R
\docType{class}
\name{Reduction-class}
\alias{Reduction-class}
\alias{accepts,Reduction,Problem-method}
\alias{reduce,Reduction-method}
\alias{retrieve,Reduction,Solution-method}
\alias{perform,Reduction,Problem-method}
\alias{invert,Reduction,Solution,list-method}
\title{The Reduction class.}
\usage{
\S4method{accepts}{Reduction,Problem}(object, problem)

\S4method{reduce}{Reduction}(object)

\S4method{retrieve}{Reduction,Solution}(object, solution)

\S4method{perform}{Reduction,Problem}(object, problem)

\S4method{invert}{Reduction,Solution,list}(object, solution, inverse_data)
}
\arguments{
\item{object}{A \linkS4class{Reduction} object.}

\item{problem}{A \linkS4class{Problem} object.}

\item{solution}{A \linkS4class{Solution} to a problem that generated the inverse data.}

\item{inverse_data}{The data encoding the original problem.}
}
\description{
This virtual class represents a reduction, an actor that transforms a problem
into an equivalent problem. By equivalent, we mean that there exists a mapping
between solutions of either problem: if we reduce a problem \eqn{A} to another
problem \eqn{B} and then proceed to find a solution to \eqn{B}, we can convert
it to a solution of \eqn{A} with at most a moderate amount of effort.
}
\details{
Every reduction supports three methods: accepts, perform, and invert. The accepts
method of a particular reduction codifies the types of problems that it is applicable
to, the perform method takes a problem and reduces it to a (new) equivalent form,
and the invert method maps solutions from reduced-to problems to their problems
of provenance.
}
\section{Methods (by generic)}{
\itemize{
\item \code{accepts}: States whether the reduction accepts a problem.

\item \code{reduce}: Reduces the owned problem to an equivalent problem.

\item \code{retrieve}: Retrieves a solution to the owned problem.

\item \code{perform}: Performs the reduction on a problem and returns an equivalent problem.

\item \code{invert}: Returns a solution to the original problem given the inverse data.
}}

