% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constant.R
\docType{class}
\name{Parameter-class}
\alias{Parameter-class}
\alias{.Parameter}
\alias{Parameter}
\alias{get_data,Parameter-method}
\alias{name,Parameter-method}
\alias{value,Parameter-method}
\alias{value<-,Parameter-method}
\alias{grad,Parameter-method}
\alias{parameters,Parameter-method}
\alias{canonicalize,Parameter-method}
\title{The Parameter class.}
\usage{
Parameter(
  rows = NULL,
  cols = NULL,
  name = NA_character_,
  value = NA_real_,
  ...
)

\S4method{get_data}{Parameter}(object)

\S4method{name}{Parameter}(x)

\S4method{value}{Parameter}(object)

\S4method{value}{Parameter}(object) <- value

\S4method{grad}{Parameter}(object)

\S4method{parameters}{Parameter}(object)

\S4method{canonicalize}{Parameter}(object)
}
\arguments{
\item{rows}{The number of rows in the parameter.}

\item{cols}{The number of columns in the parameter.}

\item{name}{(Optional) A character string representing the name of the parameter.}

\item{value}{(Optional) A numeric element, vector, matrix, or data.frame. Defaults to \code{NA} and may be changed with \code{value<-} later.}

\item{...}{Additional attribute arguments. See \linkS4class{Leaf} for details.}

\item{object, x}{A \linkS4class{Parameter} object.}
}
\description{
This class represents a parameter, either scalar or a matrix.
}
\section{Methods (by generic)}{
\itemize{
\item \code{get_data}: Returns \code{list(dim, name, value, attributes)}.

\item \code{name}: The name of the parameter.

\item \code{value}: The value of the parameter.

\item \code{value<-}: Set the value of the parameter.

\item \code{grad}: An empty list since the gradient of a parameter is zero.

\item \code{parameters}: Returns itself as a parameter.

\item \code{canonicalize}: The canonical form of the parameter.
}}

\section{Slots}{

\describe{
\item{\code{rows}}{The number of rows in the parameter.}

\item{\code{cols}}{The number of columns in the parameter.}

\item{\code{name}}{(Optional) A character string representing the name of the parameter.}

\item{\code{value}}{(Optional) A numeric element, vector, matrix, or data.frame. Defaults to \code{NA} and may be changed with \code{value<-} later.}
}}

\examples{
x <- Parameter(3, name = "x0", nonpos = TRUE) ## 3-vec negative
is_nonneg(x)
is_nonpos(x)
size(x)
}
