% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{one_minus_pos}
\alias{one_minus_pos}
\title{Difference on Restricted Domain}
\usage{
one_minus_pos(x)
}
\arguments{
\item{x}{An \linkS4class{Expression}, vector, or matrix.}
}
\value{
An \linkS4class{Expression} representing one minus the input restricted to \eqn{(0,1)}.
}
\description{
The difference \eqn{1 - x} with domain \eqn{\{x : 0 < x < 1\}}.
}
\details{
This atom is log-log concave.
}
\examples{
x <- Variable(pos = TRUE)
y <- Variable(pos = TRUE)
prob <- Problem(Maximize(one_minus_pos(x*y)), list(x <= 2 * y^2, y >= .2))
result <- solve(prob, gp = TRUE)
result$value
result$getValue(x)
result$getValue(y)

}
